@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.GetPrometheusRuleGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleGroupName The name of the rule group.
 */
public data class GetPrometheusRuleGroupPlainArgs(
    public val resourceGroupName: String,
    public val ruleGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.GetPrometheusRuleGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.alertsmanagement.inputs.GetPrometheusRuleGroupPlainArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.GetPrometheusRuleGroupPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleGroupName(ruleGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrometheusRuleGroupPlainArgs].
 */
@PulumiTagMarker
public class GetPrometheusRuleGroupPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var ruleGroupName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("faewhcxywturiujb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the rule group.
     */
    @JvmName("qpauxvpssofyfpcy")
    public suspend fun ruleGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleGroupName = mapped
    }

    internal fun build(): GetPrometheusRuleGroupPlainArgs = GetPrometheusRuleGroupPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        ruleGroupName = ruleGroupName ?: throw PulumiNullFieldException("ruleGroupName"),
    )
}
