@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleGroupActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An alert action. Only relevant for alerts.
 * @property actionGroupId The resource id of the action group to use.
 * @property actionProperties The properties of an action group object.
 */
public data class PrometheusRuleGroupActionArgs(
    public val actionGroupId: Output<String>? = null,
    public val actionProperties: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleGroupActionArgs> {
    override fun toJava():
        com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleGroupActionArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleGroupActionArgs.builder()
            .actionGroupId(actionGroupId?.applyValue({ args0 -> args0 }))
            .actionProperties(
                actionProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PrometheusRuleGroupActionArgs].
 */
@PulumiTagMarker
public class PrometheusRuleGroupActionArgsBuilder internal constructor() {
    private var actionGroupId: Output<String>? = null

    private var actionProperties: Output<Map<String, String>>? = null

    /**
     * @param value The resource id of the action group to use.
     */
    @JvmName("womdaxnxeyrjpmjq")
    public suspend fun actionGroupId(`value`: Output<String>) {
        this.actionGroupId = value
    }

    /**
     * @param value The properties of an action group object.
     */
    @JvmName("akgdfbtfafpaalmv")
    public suspend fun actionProperties(`value`: Output<Map<String, String>>) {
        this.actionProperties = value
    }

    /**
     * @param value The resource id of the action group to use.
     */
    @JvmName("tutgvnilieesnpwo")
    public suspend fun actionGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionGroupId = mapped
    }

    /**
     * @param value The properties of an action group object.
     */
    @JvmName("omaxcenyxvfcdmtq")
    public suspend fun actionProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionProperties = mapped
    }

    /**
     * @param values The properties of an action group object.
     */
    @JvmName("xhhxljvikvjohmdc")
    public fun actionProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionProperties = mapped
    }

    internal fun build(): PrometheusRuleGroupActionArgs = PrometheusRuleGroupActionArgs(
        actionGroupId = actionGroupId,
        actionProperties = actionProperties,
    )
}
