@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.SuppressionConfigArgs.builder
import com.pulumi.azurenative.alertsmanagement.kotlin.enums.SuppressionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Suppression logic for a given action rule
 * @property recurrenceType Specifies when the suppression should be applied
 * @property schedule suppression schedule configuration
 */
public data class SuppressionConfigArgs(
    public val recurrenceType: Output<Either<String, SuppressionType>>,
    public val schedule: Output<SuppressionScheduleArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.SuppressionConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.SuppressionConfigArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.SuppressionConfigArgs.builder()
            .recurrenceType(
                recurrenceType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SuppressionConfigArgs].
 */
@PulumiTagMarker
public class SuppressionConfigArgsBuilder internal constructor() {
    private var recurrenceType: Output<Either<String, SuppressionType>>? = null

    private var schedule: Output<SuppressionScheduleArgs>? = null

    /**
     * @param value Specifies when the suppression should be applied
     */
    @JvmName("wrkqyccqmrvryiql")
    public suspend fun recurrenceType(`value`: Output<Either<String, SuppressionType>>) {
        this.recurrenceType = value
    }

    /**
     * @param value suppression schedule configuration
     */
    @JvmName("baldhreohtadetua")
    public suspend fun schedule(`value`: Output<SuppressionScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value Specifies when the suppression should be applied
     */
    @JvmName("mdsmbbxecehnliqs")
    public suspend fun recurrenceType(`value`: Either<String, SuppressionType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrenceType = mapped
    }

    /**
     * @param value Specifies when the suppression should be applied
     */
    @JvmName("xphbamfbwhmwvglg")
    public fun recurrenceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SuppressionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrenceType = mapped
    }

    /**
     * @param value Specifies when the suppression should be applied
     */
    @JvmName("qmqoecaoyrvhdhnp")
    public fun recurrenceType(`value`: SuppressionType) {
        val toBeMapped = Either.ofRight<String, SuppressionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrenceType = mapped
    }

    /**
     * @param value suppression schedule configuration
     */
    @JvmName("tnkwvdyigksleveu")
    public suspend fun schedule(`value`: SuppressionScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument suppression schedule configuration
     */
    @JvmName("kqhsrcqsphjgocxq")
    public suspend fun schedule(argument: suspend SuppressionScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = SuppressionScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    internal fun build(): SuppressionConfigArgs = SuppressionConfigArgs(
        recurrenceType = recurrenceType ?: throw PulumiNullFieldException("recurrenceType"),
        schedule = schedule,
    )
}
