@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Action rule with action group configuration
 * @property actionGroupId Action group to trigger if action rule matches
 * @property conditions conditions on which alerts will be filtered
 * @property createdAt Creation time of action rule. Date-Time in ISO-8601 format.
 * @property createdBy Created by user name.
 * @property description Description of action rule
 * @property lastModifiedAt Last updated time of action rule. Date-Time in ISO-8601 format.
 * @property lastModifiedBy Last modified by user name.
 * @property scope scope on which action rule will apply
 * @property status Indicates if the given action rule is enabled or disabled
 * @property type Indicates type of action rule
 * Expected value is 'ActionGroup'.
 */
public data class ActionGroupResponse(
    public val actionGroupId: String,
    public val conditions: ConditionsResponse? = null,
    public val createdAt: String,
    public val createdBy: String,
    public val description: String? = null,
    public val lastModifiedAt: String,
    public val lastModifiedBy: String,
    public val scope: ScopeResponse? = null,
    public val status: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.ActionGroupResponse):
            ActionGroupResponse = ActionGroupResponse(
            actionGroupId = javaType.actionGroupId(),
            conditions = javaType.conditions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ConditionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            createdAt = javaType.createdAt(),
            createdBy = javaType.createdBy(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            lastModifiedAt = javaType.lastModifiedAt(),
            lastModifiedBy = javaType.lastModifiedBy(),
            scope = javaType.scope().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ScopeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
