@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Schedule for a given suppression configuration.
 * @property endDate End date for suppression
 * @property endTime End date for suppression
 * @property recurrenceValues Specifies the values for recurrence pattern
 * @property startDate Start date for suppression
 * @property startTime Start time for suppression
 */
public data class SuppressionScheduleResponse(
    public val endDate: String? = null,
    public val endTime: String? = null,
    public val recurrenceValues: List<Int>? = null,
    public val startDate: String? = null,
    public val startTime: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.SuppressionScheduleResponse):
            SuppressionScheduleResponse = SuppressionScheduleResponse(
            endDate = javaType.endDate().map({ args0 -> args0 }).orElse(null),
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            recurrenceValues = javaType.recurrenceValues().map({ args0 -> args0 }),
            startDate = javaType.startDate().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
