@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin

import com.pulumi.azurenative.apicenter.DeploymentArgs.builder
import com.pulumi.azurenative.apicenter.kotlin.enums.DeploymentState
import com.pulumi.azurenative.apicenter.kotlin.inputs.DeploymentServerArgs
import com.pulumi.azurenative.apicenter.kotlin.inputs.DeploymentServerArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * API deployment entity.
 * Azure REST API version: 2024-03-01.
 * ## Example Usage
 * ### Deployments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deployment = new AzureNative.ApiCenter.Deployment("deployment", new()
 *     {
 *         ApiName = "echo-api",
 *         DefinitionId = "/workspaces/default/apis/echo-api/versions/2023-01-01/definitions/openapi",
 *         DeploymentName = "production",
 *         Description = "Public cloud production deployment.",
 *         EnvironmentId = "/workspaces/default/environments/production",
 *         ResourceGroupName = "contoso-resources",
 *         Server = new AzureNative.ApiCenter.Inputs.DeploymentServerArgs
 *         {
 *             RuntimeUri = new[]
 *             {
 *                 "https://api.contoso.com",
 *             },
 *         },
 *         ServiceName = "contoso",
 *         State = "active",
 *         Title = "Production deployment",
 *         WorkspaceName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apicenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apicenter.NewDeployment(ctx, "deployment", &apicenter.DeploymentArgs{
 * 			ApiName:           pulumi.String("echo-api"),
 * 			DefinitionId:      pulumi.String("/workspaces/default/apis/echo-api/versions/2023-01-01/definitions/openapi"),
 * 			DeploymentName:    pulumi.String("production"),
 * 			Description:       pulumi.String("Public cloud production deployment."),
 * 			EnvironmentId:     pulumi.String("/workspaces/default/environments/production"),
 * 			ResourceGroupName: pulumi.String("contoso-resources"),
 * 			Server: &apicenter.DeploymentServerArgs{
 * 				RuntimeUri: pulumi.StringArray{
 * 					pulumi.String("https://api.contoso.com"),
 * 				},
 * 			},
 * 			ServiceName:   pulumi.String("contoso"),
 * 			State:         pulumi.String("active"),
 * 			Title:         pulumi.String("Production deployment"),
 * 			WorkspaceName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apicenter.Deployment;
 * import com.pulumi.azurenative.apicenter.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployment = new Deployment("deployment", DeploymentArgs.builder()
 *             .apiName("echo-api")
 *             .definitionId("/workspaces/default/apis/echo-api/versions/2023-01-01/definitions/openapi")
 *             .deploymentName("production")
 *             .description("Public cloud production deployment.")
 *             .environmentId("/workspaces/default/environments/production")
 *             .resourceGroupName("contoso-resources")
 *             .server(Map.of("runtimeUri", "https://api.contoso.com"))
 *             .serviceName("contoso")
 *             .state("active")
 *             .title("Production deployment")
 *             .workspaceName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apicenter:Deployment production /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/workspaces/{workspaceName}/apis/{apiName}/deployments/{deploymentName}
 * ```
 * @property apiName The name of the API.
 * @property customProperties The custom metadata defined for API catalog entities.
 * @property definitionId API center-scoped definition resource ID.
 * @property deploymentName The name of the API deployment.
 * @property description Description of the deployment.
 * @property environmentId API center-scoped environment resource ID.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property server
 * @property serviceName The name of Azure API Center service.
 * @property state State of API deployment.
 * @property title API deployment title
 * @property workspaceName The name of the workspace.
 */
public data class DeploymentArgs(
    public val apiName: Output<String>? = null,
    public val customProperties: Output<Any>? = null,
    public val definitionId: Output<String>? = null,
    public val deploymentName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val environmentId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val server: Output<DeploymentServerArgs>? = null,
    public val serviceName: Output<String>? = null,
    public val state: Output<Either<String, DeploymentState>>? = null,
    public val title: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.DeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.DeploymentArgs =
        com.pulumi.azurenative.apicenter.DeploymentArgs.builder()
            .apiName(apiName?.applyValue({ args0 -> args0 }))
            .customProperties(customProperties?.applyValue({ args0 -> args0 }))
            .definitionId(definitionId?.applyValue({ args0 -> args0 }))
            .deploymentName(deploymentName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .server(server?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .title(title?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentArgs].
 */
@PulumiTagMarker
public class DeploymentArgsBuilder internal constructor() {
    private var apiName: Output<String>? = null

    private var customProperties: Output<Any>? = null

    private var definitionId: Output<String>? = null

    private var deploymentName: Output<String>? = null

    private var description: Output<String>? = null

    private var environmentId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var server: Output<DeploymentServerArgs>? = null

    private var serviceName: Output<String>? = null

    private var state: Output<Either<String, DeploymentState>>? = null

    private var title: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of the API.
     */
    @JvmName("opsahhiplktwvylq")
    public suspend fun apiName(`value`: Output<String>) {
        this.apiName = value
    }

    /**
     * @param value The custom metadata defined for API catalog entities.
     */
    @JvmName("nxdyjuiovichhyro")
    public suspend fun customProperties(`value`: Output<Any>) {
        this.customProperties = value
    }

    /**
     * @param value API center-scoped definition resource ID.
     */
    @JvmName("dbubjbkewxjyprae")
    public suspend fun definitionId(`value`: Output<String>) {
        this.definitionId = value
    }

    /**
     * @param value The name of the API deployment.
     */
    @JvmName("rnkvrwikchighjgb")
    public suspend fun deploymentName(`value`: Output<String>) {
        this.deploymentName = value
    }

    /**
     * @param value Description of the deployment.
     */
    @JvmName("matwbjotgdncjdtu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value API center-scoped environment resource ID.
     */
    @JvmName("dvatvmebiekmhdhc")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ruvetjvhiemvilua")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("lwcfanqwqbfcaynp")
    public suspend fun server(`value`: Output<DeploymentServerArgs>) {
        this.server = value
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("ilaeofnyfyrboheu")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value State of API deployment.
     */
    @JvmName("usorlxqjqbflvhst")
    public suspend fun state(`value`: Output<Either<String, DeploymentState>>) {
        this.state = value
    }

    /**
     * @param value API deployment title
     */
    @JvmName("pgryibbsesyjaufw")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("iilvepcnxxnaflmm")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of the API.
     */
    @JvmName("ixrkjosoxdqldsoo")
    public suspend fun apiName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiName = mapped
    }

    /**
     * @param value The custom metadata defined for API catalog entities.
     */
    @JvmName("xsbcxowqkbucjfwx")
    public suspend fun customProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value API center-scoped definition resource ID.
     */
    @JvmName("vykiquufyljxpeqk")
    public suspend fun definitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definitionId = mapped
    }

    /**
     * @param value The name of the API deployment.
     */
    @JvmName("cajbqqfhjxgtgfqf")
    public suspend fun deploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentName = mapped
    }

    /**
     * @param value Description of the deployment.
     */
    @JvmName("hwpdhvimnkjwtbto")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value API center-scoped environment resource ID.
     */
    @JvmName("spjlxnxjfxvhmlro")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ooiycvqsqdovvoax")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("rekmgjptvnpemgid")
    public suspend fun server(`value`: DeploymentServerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param argument
     */
    @JvmName("itbeupqcuulddqsm")
    public suspend fun server(argument: suspend DeploymentServerArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentServerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.server = mapped
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("nopnhpimqnlvlfdh")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value State of API deployment.
     */
    @JvmName("jvgpesdelfjrbrnm")
    public suspend fun state(`value`: Either<String, DeploymentState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value State of API deployment.
     */
    @JvmName("jkqkbwxwijhtugww")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeploymentState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value State of API deployment.
     */
    @JvmName("cooipymamuefildo")
    public fun state(`value`: DeploymentState) {
        val toBeMapped = Either.ofRight<String, DeploymentState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value API deployment title
     */
    @JvmName("iangqbcklyreupna")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ulkdbteefulaweur")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): DeploymentArgs = DeploymentArgs(
        apiName = apiName,
        customProperties = customProperties,
        definitionId = definitionId,
        deploymentName = deploymentName,
        description = description,
        environmentId = environmentId,
        resourceGroupName = resourceGroupName,
        server = server,
        serviceName = serviceName,
        state = state,
        title = title,
        workspaceName = workspaceName,
    )
}
