@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Kind of API. For example, REST or GraphQL.
 */
public enum class ApiKind(
    public val javaValue: com.pulumi.azurenative.apicenter.enums.ApiKind,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.enums.ApiKind> {
    Rest(com.pulumi.azurenative.apicenter.enums.ApiKind.Rest),
    Graphql(com.pulumi.azurenative.apicenter.enums.ApiKind.Graphql),
    Grpc(com.pulumi.azurenative.apicenter.enums.ApiKind.Grpc),
    Soap(com.pulumi.azurenative.apicenter.enums.ApiKind.Soap),
    Webhook(com.pulumi.azurenative.apicenter.enums.ApiKind.Webhook),
    Websocket(com.pulumi.azurenative.apicenter.enums.ApiKind.Websocket),
    ;

    override fun toJava(): com.pulumi.azurenative.apicenter.enums.ApiKind = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apicenter.enums.ApiKind): ApiKind =
            ApiKind.values().first { it.javaValue == javaType }
    }
}
