@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of the server that represents the environment.
 */
public enum class EnvironmentServerType(
    public val javaValue: com.pulumi.azurenative.apicenter.enums.EnvironmentServerType,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.enums.EnvironmentServerType> {
    Azure_API_Management(com.pulumi.azurenative.apicenter.enums.EnvironmentServerType.Azure_API_Management),
    Azure_compute_service(com.pulumi.azurenative.apicenter.enums.EnvironmentServerType.Azure_compute_service),
    Apigee_API_Management(com.pulumi.azurenative.apicenter.enums.EnvironmentServerType.Apigee_API_Management),
    AWS_API_Gateway(com.pulumi.azurenative.apicenter.enums.EnvironmentServerType.AWS_API_Gateway),
    Kong_API_Gateway(com.pulumi.azurenative.apicenter.enums.EnvironmentServerType.Kong_API_Gateway),
    Kubernetes(com.pulumi.azurenative.apicenter.enums.EnvironmentServerType.Kubernetes),
    MuleSoft_API_Management(com.pulumi.azurenative.apicenter.enums.EnvironmentServerType.MuleSoft_API_Management),
    ;

    override fun toJava(): com.pulumi.azurenative.apicenter.enums.EnvironmentServerType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apicenter.enums.EnvironmentServerType):
            EnvironmentServerType = EnvironmentServerType.values().first { it.javaValue == javaType }
    }
}
