@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.inputs

import com.pulumi.azurenative.apicenter.inputs.OnboardingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property developerPortalUri
 * @property instructions Onboarding guide.
 */
public data class OnboardingArgs(
    public val developerPortalUri: Output<List<String>>? = null,
    public val instructions: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.inputs.OnboardingArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.inputs.OnboardingArgs =
        com.pulumi.azurenative.apicenter.inputs.OnboardingArgs.builder()
            .developerPortalUri(developerPortalUri?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .instructions(instructions?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OnboardingArgs].
 */
@PulumiTagMarker
public class OnboardingArgsBuilder internal constructor() {
    private var developerPortalUri: Output<List<String>>? = null

    private var instructions: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("vcswkrfepiwpjtlr")
    public suspend fun developerPortalUri(`value`: Output<List<String>>) {
        this.developerPortalUri = value
    }

    @JvmName("guubjujpkdsgwyeo")
    public suspend fun developerPortalUri(vararg values: Output<String>) {
        this.developerPortalUri = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("takvhnyjqcqqhrkq")
    public suspend fun developerPortalUri(values: List<Output<String>>) {
        this.developerPortalUri = Output.all(values)
    }

    /**
     * @param value Onboarding guide.
     */
    @JvmName("wvrmyoegindtytxo")
    public suspend fun instructions(`value`: Output<String>) {
        this.instructions = value
    }

    /**
     * @param value
     */
    @JvmName("ymcymtttiomdjfxa")
    public suspend fun developerPortalUri(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.developerPortalUri = mapped
    }

    /**
     * @param values
     */
    @JvmName("eynhiyyjhrddqmdi")
    public suspend fun developerPortalUri(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.developerPortalUri = mapped
    }

    /**
     * @param value Onboarding guide.
     */
    @JvmName("ldivkqsmxbjiaehl")
    public suspend fun instructions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instructions = mapped
    }

    internal fun build(): OnboardingArgs = OnboardingArgs(
        developerPortalUri = developerPortalUri,
        instructions = instructions,
    )
}
