@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property email Email address of the contact.
 * @property name Name of the contact.
 * @property url URL for the contact.
 */
public data class ContactResponse(
    public val email: String? = null,
    public val name: String? = null,
    public val url: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apicenter.outputs.ContactResponse):
            ContactResponse = ContactResponse(
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
        )
    }
}
