@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ApiArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.ApiType
import com.pulumi.azurenative.apimanagement.kotlin.enums.ContentFormat
import com.pulumi.azurenative.apimanagement.kotlin.enums.Protocol
import com.pulumi.azurenative.apimanagement.kotlin.enums.SoapApiType
import com.pulumi.azurenative.apimanagement.kotlin.enums.TranslateRequiredQueryParametersConduct
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiContactInformationArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiContactInformationArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiCreateOrUpdatePropertiesWsdlSelectorArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiCreateOrUpdatePropertiesWsdlSelectorArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiLicenseInformationArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiLicenseInformationArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiVersionSetContractDetailsArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiVersionSetContractDetailsArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.AuthenticationSettingsContractArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.AuthenticationSettingsContractArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.SubscriptionKeyParameterNamesContractArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.SubscriptionKeyParameterNamesContractArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * API details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2017-03-01, 2018-06-01-preview, 2020-12-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApi
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "tempgroup",
 *         AuthenticationSettings = new AzureNative.ApiManagement.Inputs.AuthenticationSettingsContractArgs
 *         {
 *             OAuth2 = new AzureNative.ApiManagement.Inputs.OAuth2AuthenticationSettingsContractArgs
 *             {
 *                 AuthorizationServerId = "authorizationServerId2283",
 *                 Scope = "oauth2scope2580",
 *             },
 *         },
 *         Description = "apidescription5200",
 *         DisplayName = "apiname1463",
 *         Path = "newapiPath",
 *         Protocols = new[]
 *         {
 *             "https",
 *             "http",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "http://newechoapi.cloudapp.net/api",
 *         SubscriptionKeyParameterNames = new AzureNative.ApiManagement.Inputs.SubscriptionKeyParameterNamesContractArgs
 *         {
 *             Header = "header4520",
 *             Query = "query3037",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId: pulumi.String("tempgroup"),
 * 			AuthenticationSettings: apimanagement.AuthenticationSettingsContractResponse{
 * 				OAuth2: &apimanagement.OAuth2AuthenticationSettingsContractArgs{
 * 					AuthorizationServerId: pulumi.String("authorizationServerId2283"),
 * 					Scope:                 pulumi.String("oauth2scope2580"),
 * 				},
 * 			},
 * 			Description: pulumi.String("apidescription5200"),
 * 			DisplayName: pulumi.String("apiname1463"),
 * 			Path:        pulumi.String("newapiPath"),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String("https"),
 * 				pulumi.String("http"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			ServiceUrl:        pulumi.String("http://newechoapi.cloudapp.net/api"),
 * 			SubscriptionKeyParameterNames: &apimanagement.SubscriptionKeyParameterNamesContractArgs{
 * 				Header: pulumi.String("header4520"),
 * 				Query:  pulumi.String("query3037"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("tempgroup")
 *             .authenticationSettings(Map.of("oAuth2", Map.ofEntries(
 *                 Map.entry("authorizationServerId", "authorizationServerId2283"),
 *                 Map.entry("scope", "oauth2scope2580")
 *             )))
 *             .description("apidescription5200")
 *             .displayName("apiname1463")
 *             .path("newapiPath")
 *             .protocols(
 *                 "https",
 *                 "http")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("http://newechoapi.cloudapp.net/api")
 *             .subscriptionKeyParameterNames(Map.ofEntries(
 *                 Map.entry("header", "header4520"),
 *                 Map.entry("query", "query3037")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiClone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "echo-api2",
 *         Description = "Copy of Existing Echo Api including Operations.",
 *         DisplayName = "Echo API2",
 *         IsCurrent = true,
 *         Path = "echo2",
 *         Protocols = new[]
 *         {
 *             "http",
 *             "https",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "http://echoapi.cloudapp.net/api",
 *         SourceApiId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/58a4aeac497000007d040001",
 *         SubscriptionRequired = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:       pulumi.String("echo-api2"),
 * 			Description: pulumi.String("Copy of Existing Echo Api including Operations."),
 * 			DisplayName: pulumi.String("Echo API2"),
 * 			IsCurrent:   pulumi.Bool(true),
 * 			Path:        pulumi.String("echo2"),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String("http"),
 * 				pulumi.String("https"),
 * 			},
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 			ServiceName:          pulumi.String("apimService1"),
 * 			ServiceUrl:           pulumi.String("http://echoapi.cloudapp.net/api"),
 * 			SourceApiId:          pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/58a4aeac497000007d040001"),
 * 			SubscriptionRequired: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("echo-api2")
 *             .description("Copy of Existing Echo Api including Operations.")
 *             .displayName("Echo API2")
 *             .isCurrent(true)
 *             .path("echo2")
 *             .protocols(
 *                 "http",
 *                 "https")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("http://echoapi.cloudapp.net/api")
 *             .sourceApiId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/58a4aeac497000007d040001")
 *             .subscriptionRequired(true)
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiNewVersionUsingExistingApi
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "echoapiv3",
 *         ApiVersion = "v4",
 *         ApiVersionSetId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apiVersionSets/aa9c59e6-c0cd-4258-9356-9ca7d2f0b458",
 *         Description = "Create Echo API into a new Version using Existing Version Set and Copy all Operations.",
 *         DisplayName = "Echo API2",
 *         IsCurrent = true,
 *         Path = "echo2",
 *         Protocols = new[]
 *         {
 *             "http",
 *             "https",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "http://echoapi.cloudapp.net/api",
 *         SourceApiId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echoPath",
 *         SubscriptionRequired = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:           pulumi.String("echoapiv3"),
 * 			ApiVersion:      pulumi.String("v4"),
 * 			ApiVersionSetId: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apiVersionSets/aa9c59e6-c0cd-4258-9356-9ca7d2f0b458"),
 * 			Description:     pulumi.String("Create Echo API into a new Version using Existing Version Set and Copy all Operations."),
 * 			DisplayName:     pulumi.String("Echo API2"),
 * 			IsCurrent:       pulumi.Bool(true),
 * 			Path:            pulumi.String("echo2"),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String("http"),
 * 				pulumi.String("https"),
 * 			},
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 			ServiceName:          pulumi.String("apimService1"),
 * 			ServiceUrl:           pulumi.String("http://echoapi.cloudapp.net/api"),
 * 			SourceApiId:          pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echoPath"),
 * 			SubscriptionRequired: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("echoapiv3")
 *             .apiVersion("v4")
 *             .apiVersionSetId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apiVersionSets/aa9c59e6-c0cd-4258-9356-9ca7d2f0b458")
 *             .description("Create Echo API into a new Version using Existing Version Set and Copy all Operations.")
 *             .displayName("Echo API2")
 *             .isCurrent(true)
 *             .path("echo2")
 *             .protocols(
 *                 "http",
 *                 "https")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("http://echoapi.cloudapp.net/api")
 *             .sourceApiId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echoPath")
 *             .subscriptionRequired(true)
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiRevisionFromExistingApi
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "echo-api;rev=3",
 *         ApiRevisionDescription = "Creating a Revision of an existing API",
 *         Path = "echo",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "http://echoapi.cloudapp.net/apiv3",
 *         SourceApiId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echo-api",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:                  pulumi.String("echo-api;rev=3"),
 * 			ApiRevisionDescription: pulumi.String("Creating a Revision of an existing API"),
 * 			Path:                   pulumi.String("echo"),
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 			ServiceName:            pulumi.String("apimService1"),
 * 			ServiceUrl:             pulumi.String("http://echoapi.cloudapp.net/apiv3"),
 * 			SourceApiId:            pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echo-api"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("echo-api;rev=3")
 *             .apiRevisionDescription("Creating a Revision of an existing API")
 *             .path("echo")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("http://echoapi.cloudapp.net/apiv3")
 *             .sourceApiId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echo-api")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiUsingImportOverrideServiceUrl
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "apidocs",
 *         Format = "swagger-link",
 *         Path = "petstoreapi123",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "http://petstore.swagger.wordnik.com/api",
 *         Value = "http://apimpimportviaurl.azurewebsites.net/api/apidocs/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:             pulumi.String("apidocs"),
 * 			Format:            pulumi.String("swagger-link"),
 * 			Path:              pulumi.String("petstoreapi123"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			ServiceUrl:        pulumi.String("http://petstore.swagger.wordnik.com/api"),
 * 			Value:             pulumi.String("http://apimpimportviaurl.azurewebsites.net/api/apidocs/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("apidocs")
 *             .format("swagger-link")
 *             .path("petstoreapi123")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("http://petstore.swagger.wordnik.com/api")
 *             .value("http://apimpimportviaurl.azurewebsites.net/api/apidocs/")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiUsingOai3Import
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "petstore",
 *         Format = "openapi-link",
 *         Path = "petstore",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = "https://raw.githubusercontent.com/OAI/OpenAPI-Specification/master/examples/v3.0/petstore.yaml",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:             pulumi.String("petstore"),
 * 			Format:            pulumi.String("openapi-link"),
 * 			Path:              pulumi.String("petstore"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value:             pulumi.String("https://raw.githubusercontent.com/OAI/OpenAPI-Specification/master/examples/v3.0/petstore.yaml"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("petstore")
 *             .format("openapi-link")
 *             .path("petstore")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("https://raw.githubusercontent.com/OAI/OpenAPI-Specification/master/examples/v3.0/petstore.yaml")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiUsingOai3ImportWithTranslateRequiredQueryParametersConduct
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "petstore",
 *         Format = "openapi-link",
 *         Path = "petstore",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         TranslateRequiredQueryParametersConduct = "template",
 *         Value = "https://raw.githubusercontent.com/OAI/OpenAPI-Specification/master/examples/v3.0/petstore.yaml",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:                                   pulumi.String("petstore"),
 * 			Format:                                  pulumi.String("openapi-link"),
 * 			Path:                                    pulumi.String("petstore"),
 * 			ResourceGroupName:                       pulumi.String("rg1"),
 * 			ServiceName:                             pulumi.String("apimService1"),
 * 			TranslateRequiredQueryParametersConduct: pulumi.String("template"),
 * 			Value:                                   pulumi.String("https://raw.githubusercontent.com/OAI/OpenAPI-Specification/master/examples/v3.0/petstore.yaml"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("petstore")
 *             .format("openapi-link")
 *             .path("petstore")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .translateRequiredQueryParametersConduct("template")
 *             .value("https://raw.githubusercontent.com/OAI/OpenAPI-Specification/master/examples/v3.0/petstore.yaml")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiUsingSwaggerImport
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "petstore",
 *         Format = "swagger-link-json",
 *         Path = "petstore",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = "http://petstore.swagger.io/v2/swagger.json",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:             pulumi.String("petstore"),
 * 			Format:            pulumi.String("swagger-link-json"),
 * 			Path:              pulumi.String("petstore"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value:             pulumi.String("http://petstore.swagger.io/v2/swagger.json"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("petstore")
 *             .format("swagger-link-json")
 *             .path("petstore")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("http://petstore.swagger.io/v2/swagger.json")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiUsingWadlImport
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "petstore",
 *         Format = "wadl-link-json",
 *         Path = "collector",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = "https://developer.cisco.com/media/wae-release-6-2-api-reference/wae-collector-rest-api/application.wadl",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:             pulumi.String("petstore"),
 * 			Format:            pulumi.String("wadl-link-json"),
 * 			Path:              pulumi.String("collector"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value:             pulumi.String("https://developer.cisco.com/media/wae-release-6-2-api-reference/wae-collector-rest-api/application.wadl"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("petstore")
 *             .format("wadl-link-json")
 *             .path("collector")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("https://developer.cisco.com/media/wae-release-6-2-api-reference/wae-collector-rest-api/application.wadl")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiWithMultipleAuthServers
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "tempgroup",
 *         AuthenticationSettings = new AzureNative.ApiManagement.Inputs.AuthenticationSettingsContractArgs
 *         {
 *             OAuth2AuthenticationSettings = new[]
 *             {
 *                 new AzureNative.ApiManagement.Inputs.OAuth2AuthenticationSettingsContractArgs
 *                 {
 *                     AuthorizationServerId = "authorizationServerId2283",
 *                     Scope = "oauth2scope2580",
 *                 },
 *                 new AzureNative.ApiManagement.Inputs.OAuth2AuthenticationSettingsContractArgs
 *                 {
 *                     AuthorizationServerId = "authorizationServerId2284",
 *                     Scope = "oauth2scope2581",
 *                 },
 *             },
 *         },
 *         Description = "apidescription5200",
 *         DisplayName = "apiname1463",
 *         Path = "newapiPath",
 *         Protocols = new[]
 *         {
 *             "https",
 *             "http",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "http://newechoapi.cloudapp.net/api",
 *         SubscriptionKeyParameterNames = new AzureNative.ApiManagement.Inputs.SubscriptionKeyParameterNamesContractArgs
 *         {
 *             Header = "header4520",
 *             Query = "query3037",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId: pulumi.String("tempgroup"),
 * 			AuthenticationSettings: apimanagement.AuthenticationSettingsContractResponse{
 * 				OAuth2AuthenticationSettings: apimanagement.OAuth2AuthenticationSettingsContractArray{
 * 					&apimanagement.OAuth2AuthenticationSettingsContractArgs{
 * 						AuthorizationServerId: pulumi.String("authorizationServerId2283"),
 * 						Scope:                 pulumi.String("oauth2scope2580"),
 * 					},
 * 					&apimanagement.OAuth2AuthenticationSettingsContractArgs{
 * 						AuthorizationServerId: pulumi.String("authorizationServerId2284"),
 * 						Scope:                 pulumi.String("oauth2scope2581"),
 * 					},
 * 				},
 * 			},
 * 			Description: pulumi.String("apidescription5200"),
 * 			DisplayName: pulumi.String("apiname1463"),
 * 			Path:        pulumi.String("newapiPath"),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String("https"),
 * 				pulumi.String("http"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			ServiceUrl:        pulumi.String("http://newechoapi.cloudapp.net/api"),
 * 			SubscriptionKeyParameterNames: &apimanagement.SubscriptionKeyParameterNamesContractArgs{
 * 				Header: pulumi.String("header4520"),
 * 				Query:  pulumi.String("query3037"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("tempgroup")
 *             .authenticationSettings(Map.of("oAuth2AuthenticationSettings",
 *                 Map.ofEntries(
 *                     Map.entry("authorizationServerId", "authorizationServerId2283"),
 *                     Map.entry("scope", "oauth2scope2580")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("authorizationServerId", "authorizationServerId2284"),
 *                     Map.entry("scope", "oauth2scope2581")
 *                 )))
 *             .description("apidescription5200")
 *             .displayName("apiname1463")
 *             .path("newapiPath")
 *             .protocols(
 *                 "https",
 *                 "http")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("http://newechoapi.cloudapp.net/api")
 *             .subscriptionKeyParameterNames(Map.ofEntries(
 *                 Map.entry("header", "header4520"),
 *                 Map.entry("query", "query3037")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiWithMultipleOpenIdConnectProviders
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "tempgroup",
 *         AuthenticationSettings = new AzureNative.ApiManagement.Inputs.AuthenticationSettingsContractArgs
 *         {
 *             OpenidAuthenticationSettings = new[]
 *             {
 *                 new AzureNative.ApiManagement.Inputs.OpenIdAuthenticationSettingsContractArgs
 *                 {
 *                     BearerTokenSendingMethods = new[]
 *                     {
 *                         "authorizationHeader",
 *                     },
 *                     OpenidProviderId = "openidProviderId2283",
 *                 },
 *                 new AzureNative.ApiManagement.Inputs.OpenIdAuthenticationSettingsContractArgs
 *                 {
 *                     BearerTokenSendingMethods = new[]
 *                     {
 *                         "authorizationHeader",
 *                     },
 *                     OpenidProviderId = "openidProviderId2284",
 *                 },
 *             },
 *         },
 *         Description = "apidescription5200",
 *         DisplayName = "apiname1463",
 *         Path = "newapiPath",
 *         Protocols = new[]
 *         {
 *             "https",
 *             "http",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "http://newechoapi.cloudapp.net/api",
 *         SubscriptionKeyParameterNames = new AzureNative.ApiManagement.Inputs.SubscriptionKeyParameterNamesContractArgs
 *         {
 *             Header = "header4520",
 *             Query = "query3037",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId: pulumi.String("tempgroup"),
 * 			AuthenticationSettings: apimanagement.AuthenticationSettingsContractResponse{
 * 				OpenidAuthenticationSettings: apimanagement.OpenIdAuthenticationSettingsContractArray{
 * 					&apimanagement.OpenIdAuthenticationSettingsContractArgs{
 * 						BearerTokenSendingMethods: pulumi.StringArray{
 * 							pulumi.String("authorizationHeader"),
 * 						},
 * 						OpenidProviderId: pulumi.String("openidProviderId2283"),
 * 					},
 * 					&apimanagement.OpenIdAuthenticationSettingsContractArgs{
 * 						BearerTokenSendingMethods: pulumi.StringArray{
 * 							pulumi.String("authorizationHeader"),
 * 						},
 * 						OpenidProviderId: pulumi.String("openidProviderId2284"),
 * 					},
 * 				},
 * 			},
 * 			Description: pulumi.String("apidescription5200"),
 * 			DisplayName: pulumi.String("apiname1463"),
 * 			Path:        pulumi.String("newapiPath"),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String("https"),
 * 				pulumi.String("http"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			ServiceUrl:        pulumi.String("http://newechoapi.cloudapp.net/api"),
 * 			SubscriptionKeyParameterNames: &apimanagement.SubscriptionKeyParameterNamesContractArgs{
 * 				Header: pulumi.String("header4520"),
 * 				Query:  pulumi.String("query3037"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("tempgroup")
 *             .authenticationSettings(Map.of("openidAuthenticationSettings",
 *                 Map.ofEntries(
 *                     Map.entry("bearerTokenSendingMethods", "authorizationHeader"),
 *                     Map.entry("openidProviderId", "openidProviderId2283")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("bearerTokenSendingMethods", "authorizationHeader"),
 *                     Map.entry("openidProviderId", "openidProviderId2284")
 *                 )))
 *             .description("apidescription5200")
 *             .displayName("apiname1463")
 *             .path("newapiPath")
 *             .protocols(
 *                 "https",
 *                 "http")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("http://newechoapi.cloudapp.net/api")
 *             .subscriptionKeyParameterNames(Map.ofEntries(
 *                 Map.entry("header", "header4520"),
 *                 Map.entry("query", "query3037")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiWithOpenIdConnect
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "tempgroup",
 *         AuthenticationSettings = new AzureNative.ApiManagement.Inputs.AuthenticationSettingsContractArgs
 *         {
 *             Openid = new AzureNative.ApiManagement.Inputs.OpenIdAuthenticationSettingsContractArgs
 *             {
 *                 BearerTokenSendingMethods = new[]
 *                 {
 *                     "authorizationHeader",
 *                 },
 *                 OpenidProviderId = "testopenid",
 *             },
 *         },
 *         Description = "This is a sample server Petstore server.  You can find out more about Swagger at [http://swagger.io](http://swagger.io) or on [irc.freenode.net, #swagger](http://swagger.io/irc/).  For this sample, you can use the api key `special-key` to test the authorization filters.",
 *         DisplayName = "Swagger Petstore",
 *         Path = "petstore",
 *         Protocols = new[]
 *         {
 *             "https",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "http://petstore.swagger.io/v2",
 *         SubscriptionKeyParameterNames = new AzureNative.ApiManagement.Inputs.SubscriptionKeyParameterNamesContractArgs
 *         {
 *             Header = "Ocp-Apim-Subscription-Key",
 *             Query = "subscription-key",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId: pulumi.String("tempgroup"),
 * 			AuthenticationSettings: apimanagement.AuthenticationSettingsContractResponse{
 * 				Openid: &apimanagement.OpenIdAuthenticationSettingsContractArgs{
 * 					BearerTokenSendingMethods: pulumi.StringArray{
 * 						pulumi.String("authorizationHeader"),
 * 					},
 * 					OpenidProviderId: pulumi.String("testopenid"),
 * 				},
 * 			},
 * 			Description: pulumi.String("This is a sample server Petstore server.  You can find out more about Swagger at [http://swagger.io](http://swagger.io) or on [irc.freenode.net, #swagger](http://swagger.io/irc/).  For this sample, you can use the api key `special-key` to test the authorization filters."),
 * 			DisplayName: pulumi.String("Swagger Petstore"),
 * 			Path:        pulumi.String("petstore"),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String("https"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			ServiceUrl:        pulumi.String("http://petstore.swagger.io/v2"),
 * 			SubscriptionKeyParameterNames: &apimanagement.SubscriptionKeyParameterNamesContractArgs{
 * 				Header: pulumi.String("Ocp-Apim-Subscription-Key"),
 * 				Query:  pulumi.String("subscription-key"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("tempgroup")
 *             .authenticationSettings(Map.of("openid", Map.ofEntries(
 *                 Map.entry("bearerTokenSendingMethods", "authorizationHeader"),
 *                 Map.entry("openidProviderId", "testopenid")
 *             )))
 *             .description("This is a sample server Petstore server.  You can find out more about Swagger at [http://swagger.io](http://swagger.io) or on [irc.freenode.net, #swagger](http://swagger.io/irc/).  For this sample, you can use the api key `special-key` to test the authorization filters.")
 *             .displayName("Swagger Petstore")
 *             .path("petstore")
 *             .protocols("https")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("http://petstore.swagger.io/v2")
 *             .subscriptionKeyParameterNames(Map.ofEntries(
 *                 Map.entry("header", "Ocp-Apim-Subscription-Key"),
 *                 Map.entry("query", "subscription-key")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateGraphQLApi
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "tempgroup",
 *         ApiType = "graphql",
 *         Description = "apidescription5200",
 *         DisplayName = "apiname1463",
 *         Path = "graphql-api",
 *         Protocols = new[]
 *         {
 *             "http",
 *             "https",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "https://api.spacex.land/graphql",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:       pulumi.String("tempgroup"),
 * 			ApiType:     pulumi.String("graphql"),
 * 			Description: pulumi.String("apidescription5200"),
 * 			DisplayName: pulumi.String("apiname1463"),
 * 			Path:        pulumi.String("graphql-api"),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String("http"),
 * 				pulumi.String("https"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			ServiceUrl:        pulumi.String("https://api.spacex.land/graphql"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("tempgroup")
 *             .apiType("graphql")
 *             .description("apidescription5200")
 *             .displayName("apiname1463")
 *             .path("graphql-api")
 *             .protocols(
 *                 "http",
 *                 "https")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("https://api.spacex.land/graphql")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateSoapPassThroughApiUsingWsdlImport
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "soapApi",
 *         Format = "wsdl-link",
 *         Path = "currency",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         SoapApiType = "soap",
 *         Value = "http://www.webservicex.net/CurrencyConvertor.asmx?WSDL",
 *         WsdlSelector = new AzureNative.ApiManagement.Inputs.ApiCreateOrUpdatePropertiesWsdlSelectorArgs
 *         {
 *             WsdlEndpointName = "CurrencyConvertorSoap",
 *             WsdlServiceName = "CurrencyConvertor",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:             pulumi.String("soapApi"),
 * 			Format:            pulumi.String("wsdl-link"),
 * 			Path:              pulumi.String("currency"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			SoapApiType:       pulumi.String("soap"),
 * 			Value:             pulumi.String("http://www.webservicex.net/CurrencyConvertor.asmx?WSDL"),
 * 			WsdlSelector: &apimanagement.ApiCreateOrUpdatePropertiesWsdlSelectorArgs{
 * 				WsdlEndpointName: pulumi.String("CurrencyConvertorSoap"),
 * 				WsdlServiceName:  pulumi.String("CurrencyConvertor"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("soapApi")
 *             .format("wsdl-link")
 *             .path("currency")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .soapApiType("soap")
 *             .value("http://www.webservicex.net/CurrencyConvertor.asmx?WSDL")
 *             .wsdlSelector(Map.ofEntries(
 *                 Map.entry("wsdlEndpointName", "CurrencyConvertorSoap"),
 *                 Map.entry("wsdlServiceName", "CurrencyConvertor")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateSoapToRestApiUsingWsdlImport
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "soapApi",
 *         Format = "wsdl-link",
 *         Path = "currency",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = "http://www.webservicex.net/CurrencyConvertor.asmx?WSDL",
 *         WsdlSelector = new AzureNative.ApiManagement.Inputs.ApiCreateOrUpdatePropertiesWsdlSelectorArgs
 *         {
 *             WsdlEndpointName = "CurrencyConvertorSoap",
 *             WsdlServiceName = "CurrencyConvertor",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:             pulumi.String("soapApi"),
 * 			Format:            pulumi.String("wsdl-link"),
 * 			Path:              pulumi.String("currency"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value:             pulumi.String("http://www.webservicex.net/CurrencyConvertor.asmx?WSDL"),
 * 			WsdlSelector: &apimanagement.ApiCreateOrUpdatePropertiesWsdlSelectorArgs{
 * 				WsdlEndpointName: pulumi.String("CurrencyConvertorSoap"),
 * 				WsdlServiceName:  pulumi.String("CurrencyConvertor"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("soapApi")
 *             .format("wsdl-link")
 *             .path("currency")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("http://www.webservicex.net/CurrencyConvertor.asmx?WSDL")
 *             .wsdlSelector(Map.ofEntries(
 *                 Map.entry("wsdlEndpointName", "CurrencyConvertorSoap"),
 *                 Map.entry("wsdlServiceName", "CurrencyConvertor")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateWebSocketApi
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiManagement.Api("api", new()
 *     {
 *         ApiId = "tempgroup",
 *         ApiType = "websocket",
 *         Description = "apidescription5200",
 *         DisplayName = "apiname1463",
 *         Path = "newapiPath",
 *         Protocols = new[]
 *         {
 *             "wss",
 *             "ws",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "wss://echo.websocket.org",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApi(ctx, "api", &apimanagement.ApiArgs{
 * 			ApiId:       pulumi.String("tempgroup"),
 * 			ApiType:     pulumi.String("websocket"),
 * 			Description: pulumi.String("apidescription5200"),
 * 			DisplayName: pulumi.String("apiname1463"),
 * 			Path:        pulumi.String("newapiPath"),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String("wss"),
 * 				pulumi.String("ws"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			ServiceUrl:        pulumi.String("wss://echo.websocket.org"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Api;
 * import com.pulumi.azurenative.apimanagement.ApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiId("tempgroup")
 *             .apiType("websocket")
 *             .description("apidescription5200")
 *             .displayName("apiname1463")
 *             .path("newapiPath")
 *             .protocols(
 *                 "wss",
 *                 "ws")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("wss://echo.websocket.org")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Api apiid9419 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}
 * ```
 * @property apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
 * @property apiRevision Describes the revision of the API. If no value is provided, default revision 1 is created
 * @property apiRevisionDescription Description of the API Revision.
 * @property apiType Type of API.
 * @property apiVersion Indicates the version identifier of the API if the API is versioned
 * @property apiVersionDescription Description of the API Version.
 * @property apiVersionSet Version set details
 * @property apiVersionSetId A resource identifier for the related ApiVersionSet.
 * @property authenticationSettings Collection of authentication settings included into this API.
 * @property contact Contact information for the API.
 * @property description Description of the API. May include HTML formatting tags.
 * @property displayName API name. Must be 1 to 300 characters long.
 * @property format Format of the Content in which the API is getting imported.
 * @property isCurrent Indicates if API revision is current api revision.
 * @property license License information for the API.
 * @property path Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
 * @property protocols Describes on which protocols the operations in this API can be invoked.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property serviceUrl Absolute URL of the backend service implementing this API. Cannot be more than 2000 characters long.
 * @property soapApiType Type of API to create.
 *  * `http` creates a REST API
 *  * `soap` creates a SOAP pass-through API
 *  * `websocket` creates websocket API
 *  * `graphql` creates GraphQL API.
 * @property sourceApiId API identifier of the source API.
 * @property subscriptionKeyParameterNames Protocols over which API is made available.
 * @property subscriptionRequired Specifies whether an API or Product subscription is required for accessing the API.
 * @property termsOfServiceUrl  A URL to the Terms of Service for the API. MUST be in the format of a URL.
 * @property translateRequiredQueryParametersConduct Strategy of translating required query parameters to template ones. By default has value 'template'. Possible values: 'template', 'query'
 * @property value Content value when Importing an API.
 * @property wsdlSelector Criteria to limit import of WSDL to a subset of the document.
 */
public data class ApiArgs(
    public val apiId: Output<String>? = null,
    public val apiRevision: Output<String>? = null,
    public val apiRevisionDescription: Output<String>? = null,
    public val apiType: Output<Either<String, ApiType>>? = null,
    public val apiVersion: Output<String>? = null,
    public val apiVersionDescription: Output<String>? = null,
    public val apiVersionSet: Output<ApiVersionSetContractDetailsArgs>? = null,
    public val apiVersionSetId: Output<String>? = null,
    public val authenticationSettings: Output<AuthenticationSettingsContractArgs>? = null,
    public val contact: Output<ApiContactInformationArgs>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val format: Output<Either<String, ContentFormat>>? = null,
    public val isCurrent: Output<Boolean>? = null,
    public val license: Output<ApiLicenseInformationArgs>? = null,
    public val path: Output<String>? = null,
    public val protocols: Output<List<Either<String, Protocol>>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val serviceUrl: Output<String>? = null,
    public val soapApiType: Output<Either<String, SoapApiType>>? = null,
    public val sourceApiId: Output<String>? = null,
    public val subscriptionKeyParameterNames: Output<SubscriptionKeyParameterNamesContractArgs>? =
        null,
    public val subscriptionRequired: Output<Boolean>? = null,
    public val termsOfServiceUrl: Output<String>? = null,
    public val translateRequiredQueryParametersConduct:
    Output<Either<String, TranslateRequiredQueryParametersConduct>>? = null,
    public val `value`: Output<String>? = null,
    public val wsdlSelector: Output<ApiCreateOrUpdatePropertiesWsdlSelectorArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.ApiArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.ApiArgs =
        com.pulumi.azurenative.apimanagement.ApiArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .apiRevision(apiRevision?.applyValue({ args0 -> args0 }))
            .apiRevisionDescription(apiRevisionDescription?.applyValue({ args0 -> args0 }))
            .apiType(
                apiType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .apiVersion(apiVersion?.applyValue({ args0 -> args0 }))
            .apiVersionDescription(apiVersionDescription?.applyValue({ args0 -> args0 }))
            .apiVersionSet(apiVersionSet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .apiVersionSetId(apiVersionSetId?.applyValue({ args0 -> args0 }))
            .authenticationSettings(
                authenticationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .contact(contact?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .format(
                format?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .isCurrent(isCurrent?.applyValue({ args0 -> args0 }))
            .license(license?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .path(path?.applyValue({ args0 -> args0 }))
            .protocols(
                protocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .serviceUrl(serviceUrl?.applyValue({ args0 -> args0 }))
            .soapApiType(
                soapApiType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sourceApiId(sourceApiId?.applyValue({ args0 -> args0 }))
            .subscriptionKeyParameterNames(
                subscriptionKeyParameterNames?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .subscriptionRequired(subscriptionRequired?.applyValue({ args0 -> args0 }))
            .termsOfServiceUrl(termsOfServiceUrl?.applyValue({ args0 -> args0 }))
            .translateRequiredQueryParametersConduct(
                translateRequiredQueryParametersConduct?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .wsdlSelector(wsdlSelector?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApiArgs].
 */
@PulumiTagMarker
public class ApiArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var apiRevision: Output<String>? = null

    private var apiRevisionDescription: Output<String>? = null

    private var apiType: Output<Either<String, ApiType>>? = null

    private var apiVersion: Output<String>? = null

    private var apiVersionDescription: Output<String>? = null

    private var apiVersionSet: Output<ApiVersionSetContractDetailsArgs>? = null

    private var apiVersionSetId: Output<String>? = null

    private var authenticationSettings: Output<AuthenticationSettingsContractArgs>? = null

    private var contact: Output<ApiContactInformationArgs>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var format: Output<Either<String, ContentFormat>>? = null

    private var isCurrent: Output<Boolean>? = null

    private var license: Output<ApiLicenseInformationArgs>? = null

    private var path: Output<String>? = null

    private var protocols: Output<List<Either<String, Protocol>>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var serviceUrl: Output<String>? = null

    private var soapApiType: Output<Either<String, SoapApiType>>? = null

    private var sourceApiId: Output<String>? = null

    private var subscriptionKeyParameterNames: Output<SubscriptionKeyParameterNamesContractArgs>? =
        null

    private var subscriptionRequired: Output<Boolean>? = null

    private var termsOfServiceUrl: Output<String>? = null

    private var translateRequiredQueryParametersConduct:
        Output<Either<String, TranslateRequiredQueryParametersConduct>>? = null

    private var `value`: Output<String>? = null

    private var wsdlSelector: Output<ApiCreateOrUpdatePropertiesWsdlSelectorArgs>? = null

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("bgtlvvraqweegtbg")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Describes the revision of the API. If no value is provided, default revision 1 is created
     */
    @JvmName("rnwwdhryddmbjsxj")
    public suspend fun apiRevision(`value`: Output<String>) {
        this.apiRevision = value
    }

    /**
     * @param value Description of the API Revision.
     */
    @JvmName("dqghqgprrrphtrin")
    public suspend fun apiRevisionDescription(`value`: Output<String>) {
        this.apiRevisionDescription = value
    }

    /**
     * @param value Type of API.
     */
    @JvmName("vfyweitipiumrlox")
    public suspend fun apiType(`value`: Output<Either<String, ApiType>>) {
        this.apiType = value
    }

    /**
     * @param value Indicates the version identifier of the API if the API is versioned
     */
    @JvmName("rceaqipnxtwsooxi")
    public suspend fun apiVersion(`value`: Output<String>) {
        this.apiVersion = value
    }

    /**
     * @param value Description of the API Version.
     */
    @JvmName("enrijbdncmncefgp")
    public suspend fun apiVersionDescription(`value`: Output<String>) {
        this.apiVersionDescription = value
    }

    /**
     * @param value Version set details
     */
    @JvmName("epbeaaanxjodxvgi")
    public suspend fun apiVersionSet(`value`: Output<ApiVersionSetContractDetailsArgs>) {
        this.apiVersionSet = value
    }

    /**
     * @param value A resource identifier for the related ApiVersionSet.
     */
    @JvmName("ltbedoasqnadaypf")
    public suspend fun apiVersionSetId(`value`: Output<String>) {
        this.apiVersionSetId = value
    }

    /**
     * @param value Collection of authentication settings included into this API.
     */
    @JvmName("wnoqpmtxndbpisfc")
    public suspend fun authenticationSettings(`value`: Output<AuthenticationSettingsContractArgs>) {
        this.authenticationSettings = value
    }

    /**
     * @param value Contact information for the API.
     */
    @JvmName("frorslkcweevqoit")
    public suspend fun contact(`value`: Output<ApiContactInformationArgs>) {
        this.contact = value
    }

    /**
     * @param value Description of the API. May include HTML formatting tags.
     */
    @JvmName("dhxooaovqqfhhrrl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value API name. Must be 1 to 300 characters long.
     */
    @JvmName("qtyjiulpksmuhutk")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Format of the Content in which the API is getting imported.
     */
    @JvmName("gsbtbeceaunkvvtm")
    public suspend fun format(`value`: Output<Either<String, ContentFormat>>) {
        this.format = value
    }

    /**
     * @param value Indicates if API revision is current api revision.
     */
    @JvmName("iovuntislkhyfjlk")
    public suspend fun isCurrent(`value`: Output<Boolean>) {
        this.isCurrent = value
    }

    /**
     * @param value License information for the API.
     */
    @JvmName("lqwtkwoyklaqtrcx")
    public suspend fun license(`value`: Output<ApiLicenseInformationArgs>) {
        this.license = value
    }

    /**
     * @param value Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
     */
    @JvmName("myljrgpbrwhghrgg")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Describes on which protocols the operations in this API can be invoked.
     */
    @JvmName("lyhttvsxjtwilggu")
    public suspend fun protocols(`value`: Output<List<Either<String, Protocol>>>) {
        this.protocols = value
    }

    @JvmName("jmtimrrjtondskhu")
    public suspend fun protocols(vararg values: Output<Either<String, Protocol>>) {
        this.protocols = Output.all(values.asList())
    }

    /**
     * @param values Describes on which protocols the operations in this API can be invoked.
     */
    @JvmName("unovpafugnwuumbt")
    public suspend fun protocols(values: List<Output<Either<String, Protocol>>>) {
        this.protocols = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nyqxgnkxtqqakhsu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("rqbidwvygukpjodh")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Absolute URL of the backend service implementing this API. Cannot be more than 2000 characters long.
     */
    @JvmName("nejwjdtyxidojjia")
    public suspend fun serviceUrl(`value`: Output<String>) {
        this.serviceUrl = value
    }

    /**
     * @param value Type of API to create.
     *  * `http` creates a REST API
     *  * `soap` creates a SOAP pass-through API
     *  * `websocket` creates websocket API
     *  * `graphql` creates GraphQL API.
     */
    @JvmName("qmfowovmxawdmlvl")
    public suspend fun soapApiType(`value`: Output<Either<String, SoapApiType>>) {
        this.soapApiType = value
    }

    /**
     * @param value API identifier of the source API.
     */
    @JvmName("lncbiaumovsltkqn")
    public suspend fun sourceApiId(`value`: Output<String>) {
        this.sourceApiId = value
    }

    /**
     * @param value Protocols over which API is made available.
     */
    @JvmName("xofrwsfptvjhxdoh")
    public suspend
    fun subscriptionKeyParameterNames(`value`: Output<SubscriptionKeyParameterNamesContractArgs>) {
        this.subscriptionKeyParameterNames = value
    }

    /**
     * @param value Specifies whether an API or Product subscription is required for accessing the API.
     */
    @JvmName("ytmgpsoetxquwkam")
    public suspend fun subscriptionRequired(`value`: Output<Boolean>) {
        this.subscriptionRequired = value
    }

    /**
     * @param value  A URL to the Terms of Service for the API. MUST be in the format of a URL.
     */
    @JvmName("jyaqludgjmyyvphe")
    public suspend fun termsOfServiceUrl(`value`: Output<String>) {
        this.termsOfServiceUrl = value
    }

    /**
     * @param value Strategy of translating required query parameters to template ones. By default has value 'template'. Possible values: 'template', 'query'
     */
    @JvmName("pnlajequsrxllgey")
    public suspend
    fun translateRequiredQueryParametersConduct(`value`: Output<Either<String, TranslateRequiredQueryParametersConduct>>) {
        this.translateRequiredQueryParametersConduct = value
    }

    /**
     * @param value Content value when Importing an API.
     */
    @JvmName("wpwdfasysgdefrww")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Criteria to limit import of WSDL to a subset of the document.
     */
    @JvmName("gpgdwonoyugnefyc")
    public suspend fun wsdlSelector(`value`: Output<ApiCreateOrUpdatePropertiesWsdlSelectorArgs>) {
        this.wsdlSelector = value
    }

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("mitpuqftophbckbc")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Describes the revision of the API. If no value is provided, default revision 1 is created
     */
    @JvmName("msejrcnxclrgmpwl")
    public suspend fun apiRevision(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiRevision = mapped
    }

    /**
     * @param value Description of the API Revision.
     */
    @JvmName("bmrbdqikjmbcpsmf")
    public suspend fun apiRevisionDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiRevisionDescription = mapped
    }

    /**
     * @param value Type of API.
     */
    @JvmName("jsgnopbhlrobdnej")
    public suspend fun apiType(`value`: Either<String, ApiType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiType = mapped
    }

    /**
     * @param value Type of API.
     */
    @JvmName("uaniritetqhmlqpo")
    public fun apiType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApiType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiType = mapped
    }

    /**
     * @param value Type of API.
     */
    @JvmName("fmunogpvwkkpejtj")
    public fun apiType(`value`: ApiType) {
        val toBeMapped = Either.ofRight<String, ApiType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiType = mapped
    }

    /**
     * @param value Indicates the version identifier of the API if the API is versioned
     */
    @JvmName("pihukjtanadoehir")
    public suspend fun apiVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersion = mapped
    }

    /**
     * @param value Description of the API Version.
     */
    @JvmName("luiauhdvnhjrjqph")
    public suspend fun apiVersionDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersionDescription = mapped
    }

    /**
     * @param value Version set details
     */
    @JvmName("qufyvrbttgxowycx")
    public suspend fun apiVersionSet(`value`: ApiVersionSetContractDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersionSet = mapped
    }

    /**
     * @param argument Version set details
     */
    @JvmName("twumsivqelecoxtw")
    public suspend
    fun apiVersionSet(argument: suspend ApiVersionSetContractDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ApiVersionSetContractDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apiVersionSet = mapped
    }

    /**
     * @param value A resource identifier for the related ApiVersionSet.
     */
    @JvmName("ovvswcuahhculvmy")
    public suspend fun apiVersionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersionSetId = mapped
    }

    /**
     * @param value Collection of authentication settings included into this API.
     */
    @JvmName("jsqqndgrmeeaxjrf")
    public suspend fun authenticationSettings(`value`: AuthenticationSettingsContractArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationSettings = mapped
    }

    /**
     * @param argument Collection of authentication settings included into this API.
     */
    @JvmName("tfdboegvfsaxwtjx")
    public suspend
    fun authenticationSettings(argument: suspend AuthenticationSettingsContractArgsBuilder.() -> Unit) {
        val toBeMapped = AuthenticationSettingsContractArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authenticationSettings = mapped
    }

    /**
     * @param value Contact information for the API.
     */
    @JvmName("warasbdwuhhrnuut")
    public suspend fun contact(`value`: ApiContactInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contact = mapped
    }

    /**
     * @param argument Contact information for the API.
     */
    @JvmName("oijhxtclcirhiykd")
    public suspend fun contact(argument: suspend ApiContactInformationArgsBuilder.() -> Unit) {
        val toBeMapped = ApiContactInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contact = mapped
    }

    /**
     * @param value Description of the API. May include HTML formatting tags.
     */
    @JvmName("qtuhxhpwmpmbeajy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value API name. Must be 1 to 300 characters long.
     */
    @JvmName("hqmicarmsbabsmmv")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Format of the Content in which the API is getting imported.
     */
    @JvmName("kidcsyskuwjconan")
    public suspend fun format(`value`: Either<String, ContentFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Format of the Content in which the API is getting imported.
     */
    @JvmName("xdhbranceqmmglwu")
    public fun format(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContentFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Format of the Content in which the API is getting imported.
     */
    @JvmName("smkretmkfqpkppfj")
    public fun format(`value`: ContentFormat) {
        val toBeMapped = Either.ofRight<String, ContentFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Indicates if API revision is current api revision.
     */
    @JvmName("mciycvpeecvgtvqc")
    public suspend fun isCurrent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isCurrent = mapped
    }

    /**
     * @param value License information for the API.
     */
    @JvmName("rfhsbrbdyhtcyjmx")
    public suspend fun license(`value`: ApiLicenseInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.license = mapped
    }

    /**
     * @param argument License information for the API.
     */
    @JvmName("kyjkrlclvkhhypiu")
    public suspend fun license(argument: suspend ApiLicenseInformationArgsBuilder.() -> Unit) {
        val toBeMapped = ApiLicenseInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.license = mapped
    }

    /**
     * @param value Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
     */
    @JvmName("pdgqngdlywswprma")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Describes on which protocols the operations in this API can be invoked.
     */
    @JvmName("vpraifkbmpauvdlg")
    public suspend fun protocols(`value`: List<Either<String, Protocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param values Describes on which protocols the operations in this API can be invoked.
     */
    @JvmName("ujgsewvibqywjmah")
    public suspend fun protocols(vararg values: Either<String, Protocol>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mdnbbqvahsgwygbn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("etovqvrvpvxjubwt")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Absolute URL of the backend service implementing this API. Cannot be more than 2000 characters long.
     */
    @JvmName("dqhupxkyjugiixha")
    public suspend fun serviceUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceUrl = mapped
    }

    /**
     * @param value Type of API to create.
     *  * `http` creates a REST API
     *  * `soap` creates a SOAP pass-through API
     *  * `websocket` creates websocket API
     *  * `graphql` creates GraphQL API.
     */
    @JvmName("dbvckwingrinhceg")
    public suspend fun soapApiType(`value`: Either<String, SoapApiType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.soapApiType = mapped
    }

    /**
     * @param value Type of API to create.
     *  * `http` creates a REST API
     *  * `soap` creates a SOAP pass-through API
     *  * `websocket` creates websocket API
     *  * `graphql` creates GraphQL API.
     */
    @JvmName("fierwjvxjsabcjvv")
    public fun soapApiType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SoapApiType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.soapApiType = mapped
    }

    /**
     * @param value Type of API to create.
     *  * `http` creates a REST API
     *  * `soap` creates a SOAP pass-through API
     *  * `websocket` creates websocket API
     *  * `graphql` creates GraphQL API.
     */
    @JvmName("yhulnrhamkyovsqs")
    public fun soapApiType(`value`: SoapApiType) {
        val toBeMapped = Either.ofRight<String, SoapApiType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.soapApiType = mapped
    }

    /**
     * @param value API identifier of the source API.
     */
    @JvmName("xvrltsidfmrnchwq")
    public suspend fun sourceApiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceApiId = mapped
    }

    /**
     * @param value Protocols over which API is made available.
     */
    @JvmName("ubpffgdgralbasuk")
    public suspend
    fun subscriptionKeyParameterNames(`value`: SubscriptionKeyParameterNamesContractArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionKeyParameterNames = mapped
    }

    /**
     * @param argument Protocols over which API is made available.
     */
    @JvmName("kxfalfyvmgawtyvl")
    public suspend
    fun subscriptionKeyParameterNames(argument: suspend SubscriptionKeyParameterNamesContractArgsBuilder.() -> Unit) {
        val toBeMapped = SubscriptionKeyParameterNamesContractArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.subscriptionKeyParameterNames = mapped
    }

    /**
     * @param value Specifies whether an API or Product subscription is required for accessing the API.
     */
    @JvmName("rynxjwnraovvjlwr")
    public suspend fun subscriptionRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionRequired = mapped
    }

    /**
     * @param value  A URL to the Terms of Service for the API. MUST be in the format of a URL.
     */
    @JvmName("hmbstumtggjaklue")
    public suspend fun termsOfServiceUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.termsOfServiceUrl = mapped
    }

    /**
     * @param value Strategy of translating required query parameters to template ones. By default has value 'template'. Possible values: 'template', 'query'
     */
    @JvmName("gpttueemnghnwfgj")
    public suspend
    fun translateRequiredQueryParametersConduct(`value`: Either<String, TranslateRequiredQueryParametersConduct>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.translateRequiredQueryParametersConduct = mapped
    }

    /**
     * @param value Strategy of translating required query parameters to template ones. By default has value 'template'. Possible values: 'template', 'query'
     */
    @JvmName("wiuxnkcealkuhqis")
    public fun translateRequiredQueryParametersConduct(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TranslateRequiredQueryParametersConduct>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.translateRequiredQueryParametersConduct = mapped
    }

    /**
     * @param value Strategy of translating required query parameters to template ones. By default has value 'template'. Possible values: 'template', 'query'
     */
    @JvmName("nniselelsroxdtoe")
    public
    fun translateRequiredQueryParametersConduct(`value`: TranslateRequiredQueryParametersConduct) {
        val toBeMapped = Either.ofRight<String, TranslateRequiredQueryParametersConduct>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.translateRequiredQueryParametersConduct = mapped
    }

    /**
     * @param value Content value when Importing an API.
     */
    @JvmName("vplewfreycdpiyol")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value Criteria to limit import of WSDL to a subset of the document.
     */
    @JvmName("wanlnxdhbqwptvff")
    public suspend fun wsdlSelector(`value`: ApiCreateOrUpdatePropertiesWsdlSelectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wsdlSelector = mapped
    }

    /**
     * @param argument Criteria to limit import of WSDL to a subset of the document.
     */
    @JvmName("vnrrgwjstdpfpygu")
    public suspend
    fun wsdlSelector(argument: suspend ApiCreateOrUpdatePropertiesWsdlSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = ApiCreateOrUpdatePropertiesWsdlSelectorArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.wsdlSelector = mapped
    }

    internal fun build(): ApiArgs = ApiArgs(
        apiId = apiId,
        apiRevision = apiRevision,
        apiRevisionDescription = apiRevisionDescription,
        apiType = apiType,
        apiVersion = apiVersion,
        apiVersionDescription = apiVersionDescription,
        apiVersionSet = apiVersionSet,
        apiVersionSetId = apiVersionSetId,
        authenticationSettings = authenticationSettings,
        contact = contact,
        description = description,
        displayName = displayName,
        format = format,
        isCurrent = isCurrent,
        license = license,
        path = path,
        protocols = protocols,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        serviceUrl = serviceUrl,
        soapApiType = soapApiType,
        sourceApiId = sourceApiId,
        subscriptionKeyParameterNames = subscriptionKeyParameterNames,
        subscriptionRequired = subscriptionRequired,
        termsOfServiceUrl = termsOfServiceUrl,
        translateRequiredQueryParametersConduct = translateRequiredQueryParametersConduct,
        `value` = `value`,
        wsdlSelector = wsdlSelector,
    )
}
