@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ApiDiagnosticArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.AlwaysLog
import com.pulumi.azurenative.apimanagement.kotlin.enums.HttpCorrelationProtocol
import com.pulumi.azurenative.apimanagement.kotlin.enums.OperationNameFormat
import com.pulumi.azurenative.apimanagement.kotlin.enums.Verbosity
import com.pulumi.azurenative.apimanagement.kotlin.inputs.PipelineDiagnosticSettingsArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.PipelineDiagnosticSettingsArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.SamplingSettingsArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.SamplingSettingsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Diagnostic details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2018-01-01, 2019-01-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiDiagnostic
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiDiagnostic = new AzureNative.ApiManagement.ApiDiagnostic("apiDiagnostic", new()
 *     {
 *         AlwaysLog = "allErrors",
 *         ApiId = "57d1f7558aa04f15146d9d8a",
 *         Backend = new AzureNative.ApiManagement.Inputs.PipelineDiagnosticSettingsArgs
 *         {
 *             Request = new AzureNative.ApiManagement.Inputs.HttpMessageDiagnosticArgs
 *             {
 *                 Body = new AzureNative.ApiManagement.Inputs.BodyDiagnosticSettingsArgs
 *                 {
 *                     Bytes = 512,
 *                 },
 *                 Headers = new[]
 *                 {
 *                     "Content-type",
 *                 },
 *             },
 *             Response = new AzureNative.ApiManagement.Inputs.HttpMessageDiagnosticArgs
 *             {
 *                 Body = new AzureNative.ApiManagement.Inputs.BodyDiagnosticSettingsArgs
 *                 {
 *                     Bytes = 512,
 *                 },
 *                 Headers = new[]
 *                 {
 *                     "Content-type",
 *                 },
 *             },
 *         },
 *         DiagnosticId = "applicationinsights",
 *         Frontend = new AzureNative.ApiManagement.Inputs.PipelineDiagnosticSettingsArgs
 *         {
 *             Request = new AzureNative.ApiManagement.Inputs.HttpMessageDiagnosticArgs
 *             {
 *                 Body = new AzureNative.ApiManagement.Inputs.BodyDiagnosticSettingsArgs
 *                 {
 *                     Bytes = 512,
 *                 },
 *                 Headers = new[]
 *                 {
 *                     "Content-type",
 *                 },
 *             },
 *             Response = new AzureNative.ApiManagement.Inputs.HttpMessageDiagnosticArgs
 *             {
 *                 Body = new AzureNative.ApiManagement.Inputs.BodyDiagnosticSettingsArgs
 *                 {
 *                     Bytes = 512,
 *                 },
 *                 Headers = new[]
 *                 {
 *                     "Content-type",
 *                 },
 *             },
 *         },
 *         LoggerId = "/loggers/applicationinsights",
 *         ResourceGroupName = "rg1",
 *         Sampling = new AzureNative.ApiManagement.Inputs.SamplingSettingsArgs
 *         {
 *             Percentage = 50,
 *             SamplingType = "fixed",
 *         },
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := apimanagement.NewApiDiagnostic(ctx, "apiDiagnostic", &apimanagement.ApiDiagnosticArgs{
 * AlwaysLog: pulumi.String("allErrors"),
 * ApiId: pulumi.String("57d1f7558aa04f15146d9d8a"),
 * Backend: apimanagement.PipelineDiagnosticSettingsResponse{
 * Request: interface{}{
 * Body: &apimanagement.BodyDiagnosticSettingsArgs{
 * Bytes: pulumi.Int(512),
 * },
 * Headers: pulumi.StringArray{
 * pulumi.String("Content-type"),
 * },
 * },
 * Response: interface{}{
 * Body: &apimanagement.BodyDiagnosticSettingsArgs{
 * Bytes: pulumi.Int(512),
 * },
 * Headers: pulumi.StringArray{
 * pulumi.String("Content-type"),
 * },
 * },
 * },
 * DiagnosticId: pulumi.String("applicationinsights"),
 * Frontend: apimanagement.PipelineDiagnosticSettingsResponse{
 * Request: interface{}{
 * Body: &apimanagement.BodyDiagnosticSettingsArgs{
 * Bytes: pulumi.Int(512),
 * },
 * Headers: pulumi.StringArray{
 * pulumi.String("Content-type"),
 * },
 * },
 * Response: interface{}{
 * Body: &apimanagement.BodyDiagnosticSettingsArgs{
 * Bytes: pulumi.Int(512),
 * },
 * Headers: pulumi.StringArray{
 * pulumi.String("Content-type"),
 * },
 * },
 * },
 * LoggerId: pulumi.String("/loggers/applicationinsights"),
 * ResourceGroupName: pulumi.String("rg1"),
 * Sampling: &apimanagement.SamplingSettingsArgs{
 * Percentage: pulumi.Float64(50),
 * SamplingType: pulumi.String("fixed"),
 * },
 * ServiceName: pulumi.String("apimService1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiDiagnostic;
 * import com.pulumi.azurenative.apimanagement.ApiDiagnosticArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiDiagnostic = new ApiDiagnostic("apiDiagnostic", ApiDiagnosticArgs.builder()
 *             .alwaysLog("allErrors")
 *             .apiId("57d1f7558aa04f15146d9d8a")
 *             .backend(Map.ofEntries(
 *                 Map.entry("request", Map.ofEntries(
 *                     Map.entry("body", Map.of("bytes", 512)),
 *                     Map.entry("headers", "Content-type")
 *                 )),
 *                 Map.entry("response", Map.ofEntries(
 *                     Map.entry("body", Map.of("bytes", 512)),
 *                     Map.entry("headers", "Content-type")
 *                 ))
 *             ))
 *             .diagnosticId("applicationinsights")
 *             .frontend(Map.ofEntries(
 *                 Map.entry("request", Map.ofEntries(
 *                     Map.entry("body", Map.of("bytes", 512)),
 *                     Map.entry("headers", "Content-type")
 *                 )),
 *                 Map.entry("response", Map.ofEntries(
 *                     Map.entry("body", Map.of("bytes", 512)),
 *                     Map.entry("headers", "Content-type")
 *                 ))
 *             ))
 *             .loggerId("/loggers/applicationinsights")
 *             .resourceGroupName("rg1")
 *             .sampling(Map.ofEntries(
 *                 Map.entry("percentage", 50),
 *                 Map.entry("samplingType", "fixed")
 *             ))
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiDiagnostic applicationinsights /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/diagnostics/{diagnosticId}
 * ```
 * @property alwaysLog Specifies for what type of messages sampling settings should not apply.
 * @property apiId API identifier. Must be unique in the current API Management service instance.
 * @property backend Diagnostic settings for incoming/outgoing HTTP messages to the Backend
 * @property diagnosticId Diagnostic identifier. Must be unique in the current API Management service instance.
 * @property frontend Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
 * @property httpCorrelationProtocol Sets correlation protocol to use for Application Insights diagnostics.
 * @property logClientIp Log the ClientIP. Default is false.
 * @property loggerId Resource Id of a target logger.
 * @property metrics Emit custom metrics via emit-metric policy. Applicable only to Application Insights diagnostic settings.
 * @property operationNameFormat The format of the Operation Name for Application Insights telemetries. Default is Name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sampling Sampling settings for Diagnostic.
 * @property serviceName The name of the API Management service.
 * @property verbosity The verbosity level applied to traces emitted by trace policies.
 */
public data class ApiDiagnosticArgs(
    public val alwaysLog: Output<Either<String, AlwaysLog>>? = null,
    public val apiId: Output<String>? = null,
    public val backend: Output<PipelineDiagnosticSettingsArgs>? = null,
    public val diagnosticId: Output<String>? = null,
    public val frontend: Output<PipelineDiagnosticSettingsArgs>? = null,
    public val httpCorrelationProtocol: Output<Either<String, HttpCorrelationProtocol>>? = null,
    public val logClientIp: Output<Boolean>? = null,
    public val loggerId: Output<String>? = null,
    public val metrics: Output<Boolean>? = null,
    public val operationNameFormat: Output<Either<String, OperationNameFormat>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sampling: Output<SamplingSettingsArgs>? = null,
    public val serviceName: Output<String>? = null,
    public val verbosity: Output<Either<String, Verbosity>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.ApiDiagnosticArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.ApiDiagnosticArgs =
        com.pulumi.azurenative.apimanagement.ApiDiagnosticArgs.builder()
            .alwaysLog(
                alwaysLog?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .backend(backend?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .diagnosticId(diagnosticId?.applyValue({ args0 -> args0 }))
            .frontend(frontend?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpCorrelationProtocol(
                httpCorrelationProtocol?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .logClientIp(logClientIp?.applyValue({ args0 -> args0 }))
            .loggerId(loggerId?.applyValue({ args0 -> args0 }))
            .metrics(metrics?.applyValue({ args0 -> args0 }))
            .operationNameFormat(
                operationNameFormat?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sampling(sampling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .verbosity(
                verbosity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApiDiagnosticArgs].
 */
@PulumiTagMarker
public class ApiDiagnosticArgsBuilder internal constructor() {
    private var alwaysLog: Output<Either<String, AlwaysLog>>? = null

    private var apiId: Output<String>? = null

    private var backend: Output<PipelineDiagnosticSettingsArgs>? = null

    private var diagnosticId: Output<String>? = null

    private var frontend: Output<PipelineDiagnosticSettingsArgs>? = null

    private var httpCorrelationProtocol: Output<Either<String, HttpCorrelationProtocol>>? = null

    private var logClientIp: Output<Boolean>? = null

    private var loggerId: Output<String>? = null

    private var metrics: Output<Boolean>? = null

    private var operationNameFormat: Output<Either<String, OperationNameFormat>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sampling: Output<SamplingSettingsArgs>? = null

    private var serviceName: Output<String>? = null

    private var verbosity: Output<Either<String, Verbosity>>? = null

    /**
     * @param value Specifies for what type of messages sampling settings should not apply.
     */
    @JvmName("hyngqhvvnxvgfycq")
    public suspend fun alwaysLog(`value`: Output<Either<String, AlwaysLog>>) {
        this.alwaysLog = value
    }

    /**
     * @param value API identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("wduexolukabnpvta")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Diagnostic settings for incoming/outgoing HTTP messages to the Backend
     */
    @JvmName("lymixcelxxltjgld")
    public suspend fun backend(`value`: Output<PipelineDiagnosticSettingsArgs>) {
        this.backend = value
    }

    /**
     * @param value Diagnostic identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("uyffuvmelypghkyt")
    public suspend fun diagnosticId(`value`: Output<String>) {
        this.diagnosticId = value
    }

    /**
     * @param value Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
     */
    @JvmName("qfhwjhxglfppbfug")
    public suspend fun frontend(`value`: Output<PipelineDiagnosticSettingsArgs>) {
        this.frontend = value
    }

    /**
     * @param value Sets correlation protocol to use for Application Insights diagnostics.
     */
    @JvmName("tjtnvbarfmxkstpa")
    public suspend
    fun httpCorrelationProtocol(`value`: Output<Either<String, HttpCorrelationProtocol>>) {
        this.httpCorrelationProtocol = value
    }

    /**
     * @param value Log the ClientIP. Default is false.
     */
    @JvmName("cmxdtmeliwlvugmy")
    public suspend fun logClientIp(`value`: Output<Boolean>) {
        this.logClientIp = value
    }

    /**
     * @param value Resource Id of a target logger.
     */
    @JvmName("gbavglfuheldxmqk")
    public suspend fun loggerId(`value`: Output<String>) {
        this.loggerId = value
    }

    /**
     * @param value Emit custom metrics via emit-metric policy. Applicable only to Application Insights diagnostic settings.
     */
    @JvmName("edtypykcwresihxx")
    public suspend fun metrics(`value`: Output<Boolean>) {
        this.metrics = value
    }

    /**
     * @param value The format of the Operation Name for Application Insights telemetries. Default is Name.
     */
    @JvmName("btxchxjjrynohooi")
    public suspend fun operationNameFormat(`value`: Output<Either<String, OperationNameFormat>>) {
        this.operationNameFormat = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wpnmggghtxgujudb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Sampling settings for Diagnostic.
     */
    @JvmName("ahoeknrgsfqrwota")
    public suspend fun sampling(`value`: Output<SamplingSettingsArgs>) {
        this.sampling = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("lytwcycuruujmfke")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The verbosity level applied to traces emitted by trace policies.
     */
    @JvmName("kutgbfmyjafghcrh")
    public suspend fun verbosity(`value`: Output<Either<String, Verbosity>>) {
        this.verbosity = value
    }

    /**
     * @param value Specifies for what type of messages sampling settings should not apply.
     */
    @JvmName("goinveqckifbmoji")
    public suspend fun alwaysLog(`value`: Either<String, AlwaysLog>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alwaysLog = mapped
    }

    /**
     * @param value Specifies for what type of messages sampling settings should not apply.
     */
    @JvmName("btcbrkqknklmaohy")
    public fun alwaysLog(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AlwaysLog>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alwaysLog = mapped
    }

    /**
     * @param value Specifies for what type of messages sampling settings should not apply.
     */
    @JvmName("hpdevhdcvgydxlth")
    public fun alwaysLog(`value`: AlwaysLog) {
        val toBeMapped = Either.ofRight<String, AlwaysLog>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alwaysLog = mapped
    }

    /**
     * @param value API identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("whqgnemsouasligq")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Diagnostic settings for incoming/outgoing HTTP messages to the Backend
     */
    @JvmName("tpcgeksputaodpxf")
    public suspend fun backend(`value`: PipelineDiagnosticSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backend = mapped
    }

    /**
     * @param argument Diagnostic settings for incoming/outgoing HTTP messages to the Backend
     */
    @JvmName("fiaqjphfhbxsikdi")
    public suspend fun backend(argument: suspend PipelineDiagnosticSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineDiagnosticSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backend = mapped
    }

    /**
     * @param value Diagnostic identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("menkydnweffonwtm")
    public suspend fun diagnosticId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnosticId = mapped
    }

    /**
     * @param value Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
     */
    @JvmName("umceacjyqscdqrdt")
    public suspend fun frontend(`value`: PipelineDiagnosticSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontend = mapped
    }

    /**
     * @param argument Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
     */
    @JvmName("odaouqdbfufdqppf")
    public suspend fun frontend(argument: suspend PipelineDiagnosticSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineDiagnosticSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.frontend = mapped
    }

    /**
     * @param value Sets correlation protocol to use for Application Insights diagnostics.
     */
    @JvmName("etgijuneyyfxoolw")
    public suspend fun httpCorrelationProtocol(`value`: Either<String, HttpCorrelationProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpCorrelationProtocol = mapped
    }

    /**
     * @param value Sets correlation protocol to use for Application Insights diagnostics.
     */
    @JvmName("ttfsodlkkrelvvgo")
    public fun httpCorrelationProtocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HttpCorrelationProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpCorrelationProtocol = mapped
    }

    /**
     * @param value Sets correlation protocol to use for Application Insights diagnostics.
     */
    @JvmName("yjkcsswdloeylcyw")
    public fun httpCorrelationProtocol(`value`: HttpCorrelationProtocol) {
        val toBeMapped = Either.ofRight<String, HttpCorrelationProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpCorrelationProtocol = mapped
    }

    /**
     * @param value Log the ClientIP. Default is false.
     */
    @JvmName("xnbaxvmvuvrvicvv")
    public suspend fun logClientIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logClientIp = mapped
    }

    /**
     * @param value Resource Id of a target logger.
     */
    @JvmName("cksllcclgqvfogps")
    public suspend fun loggerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggerId = mapped
    }

    /**
     * @param value Emit custom metrics via emit-metric policy. Applicable only to Application Insights diagnostic settings.
     */
    @JvmName("rqifamsexmoemrtv")
    public suspend fun metrics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param value The format of the Operation Name for Application Insights telemetries. Default is Name.
     */
    @JvmName("hpkclddveoovocmk")
    public suspend fun operationNameFormat(`value`: Either<String, OperationNameFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationNameFormat = mapped
    }

    /**
     * @param value The format of the Operation Name for Application Insights telemetries. Default is Name.
     */
    @JvmName("luxvlqrtjljmdyou")
    public fun operationNameFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OperationNameFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operationNameFormat = mapped
    }

    /**
     * @param value The format of the Operation Name for Application Insights telemetries. Default is Name.
     */
    @JvmName("gsrhooqbqnjuftwp")
    public fun operationNameFormat(`value`: OperationNameFormat) {
        val toBeMapped = Either.ofRight<String, OperationNameFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operationNameFormat = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mehcfbkiaquctbdy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Sampling settings for Diagnostic.
     */
    @JvmName("vkgnjjfddiyaoghu")
    public suspend fun sampling(`value`: SamplingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sampling = mapped
    }

    /**
     * @param argument Sampling settings for Diagnostic.
     */
    @JvmName("fsfdrdnqkmdxnufb")
    public suspend fun sampling(argument: suspend SamplingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SamplingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sampling = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("htefrtfyybfptlki")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value The verbosity level applied to traces emitted by trace policies.
     */
    @JvmName("lcjohhdgqmaqypfi")
    public suspend fun verbosity(`value`: Either<String, Verbosity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verbosity = mapped
    }

    /**
     * @param value The verbosity level applied to traces emitted by trace policies.
     */
    @JvmName("hyypwaornhapvslh")
    public fun verbosity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Verbosity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.verbosity = mapped
    }

    /**
     * @param value The verbosity level applied to traces emitted by trace policies.
     */
    @JvmName("gvhlxdkjrfjujeox")
    public fun verbosity(`value`: Verbosity) {
        val toBeMapped = Either.ofRight<String, Verbosity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.verbosity = mapped
    }

    internal fun build(): ApiDiagnosticArgs = ApiDiagnosticArgs(
        alwaysLog = alwaysLog,
        apiId = apiId,
        backend = backend,
        diagnosticId = diagnosticId,
        frontend = frontend,
        httpCorrelationProtocol = httpCorrelationProtocol,
        logClientIp = logClientIp,
        loggerId = loggerId,
        metrics = metrics,
        operationNameFormat = operationNameFormat,
        resourceGroupName = resourceGroupName,
        sampling = sampling,
        serviceName = serviceName,
        verbosity = verbosity,
    )
}
