@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.kotlin.outputs.AdditionalLocationResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiManagementServiceIdentityResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiManagementServiceSkuPropertiesResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiVersionConstraintResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.CertificateConfigurationResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.HostnameConfigurationResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.RemotePrivateEndpointConnectionWrapperResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.VirtualNetworkConfigurationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.apimanagement.kotlin.outputs.AdditionalLocationResponse.Companion.toKotlin as additionalLocationResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiManagementServiceIdentityResponse.Companion.toKotlin as apiManagementServiceIdentityResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiManagementServiceSkuPropertiesResponse.Companion.toKotlin as apiManagementServiceSkuPropertiesResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiVersionConstraintResponse.Companion.toKotlin as apiVersionConstraintResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.CertificateConfigurationResponse.Companion.toKotlin as certificateConfigurationResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.HostnameConfigurationResponse.Companion.toKotlin as hostnameConfigurationResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.RemotePrivateEndpointConnectionWrapperResponse.Companion.toKotlin as remotePrivateEndpointConnectionWrapperResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.VirtualNetworkConfigurationResponse.Companion.toKotlin as virtualNetworkConfigurationResponseToKotlin

/**
 * Builder for [ApiManagementService].
 */
@PulumiTagMarker
public class ApiManagementServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiManagementServiceArgs = ApiManagementServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiManagementServiceArgsBuilder.() -> Unit) {
        val builder = ApiManagementServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ApiManagementService {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.ApiManagementService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApiManagementService(builtJavaResource)
    }
}

/**
 * A single API Management service resource in List or Get response.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2017-03-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateMultiRegionServiceWithCustomHostname
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         AdditionalLocations = new[]
 *         {
 *             new AzureNative.ApiManagement.Inputs.AdditionalLocationArgs
 *             {
 *                 DisableGateway = true,
 *                 Location = "East US",
 *                 Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *                 {
 *                     Capacity = 1,
 *                     Name = "Premium",
 *                 },
 *             },
 *         },
 *         ApiVersionConstraint = new AzureNative.ApiManagement.Inputs.ApiVersionConstraintArgs
 *         {
 *             MinApiVersion = "2019-01-01",
 *         },
 *         HostnameConfigurations = new[]
 *         {
 *             new AzureNative.ApiManagement.Inputs.HostnameConfigurationArgs
 *             {
 *                 CertificatePassword = "Password",
 *                 DefaultSslBinding = true,
 *                 EncodedCertificate = "****** Base 64 Encoded Certificate ************",
 *                 HostName = "gateway1.msitesting.net",
 *                 Type = "Proxy",
 *             },
 *             new AzureNative.ApiManagement.Inputs.HostnameConfigurationArgs
 *             {
 *                 CertificatePassword = "Password",
 *                 EncodedCertificate = "****** Base 64 Encoded Certificate ************",
 *                 HostName = "mgmt.msitesting.net",
 *                 Type = "Management",
 *             },
 *             new AzureNative.ApiManagement.Inputs.HostnameConfigurationArgs
 *             {
 *                 CertificatePassword = "Password",
 *                 EncodedCertificate = "****** Base 64 Encoded Certificate ************",
 *                 HostName = "portal1.msitesting.net",
 *                 Type = "Portal",
 *             },
 *         },
 *         Location = "West US",
 *         PublisherEmail = "apim@autorestsdk.com",
 *         PublisherName = "autorestsdk",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 1,
 *             Name = "Premium",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *             { "tag3", "value3" },
 *         },
 *         VirtualNetworkType = "None",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			AdditionalLocations: []apimanagement.AdditionalLocationArgs{
 * 				{
 * 					DisableGateway: pulumi.Bool(true),
 * 					Location:       pulumi.String("East US"),
 * 					Sku: {
 * 						Capacity: pulumi.Int(1),
 * 						Name:     pulumi.String("Premium"),
 * 					},
 * 				},
 * 			},
 * 			ApiVersionConstraint: &apimanagement.ApiVersionConstraintArgs{
 * 				MinApiVersion: pulumi.String("2019-01-01"),
 * 			},
 * 			HostnameConfigurations: []apimanagement.HostnameConfigurationArgs{
 * 				{
 * 					CertificatePassword: pulumi.String("Password"),
 * 					DefaultSslBinding:   pulumi.Bool(true),
 * 					EncodedCertificate:  pulumi.String("****** Base 64 Encoded Certificate ************"),
 * 					HostName:            pulumi.String("gateway1.msitesting.net"),
 * 					Type:                pulumi.String("Proxy"),
 * 				},
 * 				{
 * 					CertificatePassword: pulumi.String("Password"),
 * 					EncodedCertificate:  pulumi.String("****** Base 64 Encoded Certificate ************"),
 * 					HostName:            pulumi.String("mgmt.msitesting.net"),
 * 					Type:                pulumi.String("Management"),
 * 				},
 * 				{
 * 					CertificatePassword: pulumi.String("Password"),
 * 					EncodedCertificate:  pulumi.String("****** Base 64 Encoded Certificate ************"),
 * 					HostName:            pulumi.String("portal1.msitesting.net"),
 * 					Type:                pulumi.String("Portal"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			PublisherEmail:    pulumi.String("apim@autorestsdk.com"),
 * 			PublisherName:     pulumi.String("autorestsdk"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("Premium"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 				"tag3": pulumi.String("value3"),
 * 			},
 * 			VirtualNetworkType: pulumi.String("None"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .additionalLocations(Map.ofEntries(
 *                 Map.entry("disableGateway", true),
 *                 Map.entry("location", "East US"),
 *                 Map.entry("sku", Map.ofEntries(
 *                     Map.entry("capacity", 1),
 *                     Map.entry("name", "Premium")
 *                 ))
 *             ))
 *             .apiVersionConstraint(Map.of("minApiVersion", "2019-01-01"))
 *             .hostnameConfigurations(
 *                 Map.ofEntries(
 *                     Map.entry("certificatePassword", "Password"),
 *                     Map.entry("defaultSslBinding", true),
 *                     Map.entry("encodedCertificate", "****** Base 64 Encoded Certificate ************"),
 *                     Map.entry("hostName", "gateway1.msitesting.net"),
 *                     Map.entry("type", "Proxy")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("certificatePassword", "Password"),
 *                     Map.entry("encodedCertificate", "****** Base 64 Encoded Certificate ************"),
 *                     Map.entry("hostName", "mgmt.msitesting.net"),
 *                     Map.entry("type", "Management")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("certificatePassword", "Password"),
 *                     Map.entry("encodedCertificate", "****** Base 64 Encoded Certificate ************"),
 *                     Map.entry("hostName", "portal1.msitesting.net"),
 *                     Map.entry("type", "Portal")
 *                 ))
 *             .location("West US")
 *             .publisherEmail("apim@autorestsdk.com")
 *             .publisherName("autorestsdk")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("name", "Premium")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2"),
 *                 Map.entry("tag3", "value3")
 *             ))
 *             .virtualNetworkType("None")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateService
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         Location = "South Central US",
 *         PublisherEmail = "foo@contoso.com",
 *         PublisherName = "foo",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 1,
 *             Name = "Developer",
 *         },
 *         Tags =
 *         {
 *             { "Name", "Contoso" },
 *             { "Test", "User" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			Location:          pulumi.String("South Central US"),
 * 			PublisherEmail:    pulumi.String("foo@contoso.com"),
 * 			PublisherName:     pulumi.String("foo"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("Developer"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Contoso"),
 * 				"Test": pulumi.String("User"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .location("South Central US")
 *             .publisherEmail("foo@contoso.com")
 *             .publisherName("foo")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("name", "Developer")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "Contoso"),
 *                 Map.entry("Test", "User")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateServiceHavingMsi
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         Identity = new AzureNative.ApiManagement.Inputs.ApiManagementServiceIdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         Location = "West US",
 *         PublisherEmail = "apim@autorestsdk.com",
 *         PublisherName = "autorestsdk",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 0,
 *             Name = "Consumption",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *             { "tag3", "value3" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			Identity: &apimanagement.ApiManagementServiceIdentityArgs{
 * 				Type: pulumi.String("SystemAssigned"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			PublisherEmail:    pulumi.String("apim@autorestsdk.com"),
 * 			PublisherName:     pulumi.String("autorestsdk"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(0),
 * 				Name:     pulumi.String("Consumption"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 				"tag3": pulumi.String("value3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .location("West US")
 *             .publisherEmail("apim@autorestsdk.com")
 *             .publisherName("autorestsdk")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 0),
 *                 Map.entry("name", "Consumption")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2"),
 *                 Map.entry("tag3", "value3")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateServiceInVnetWithPublicIP
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         Location = "East US 2 EUAP",
 *         PublicIpAddressId = "/subscriptions/subid/resourceGroups/rgName/providers/Microsoft.Network/publicIPAddresses/apimazvnet",
 *         PublisherEmail = "apim@autorestsdk.com",
 *         PublisherName = "autorestsdk",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 2,
 *             Name = "Premium",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *             { "tag3", "value3" },
 *         },
 *         VirtualNetworkConfiguration = new AzureNative.ApiManagement.Inputs.VirtualNetworkConfigurationArgs
 *         {
 *             SubnetResourceId = "/subscriptions/subid/resourceGroups/rgName/providers/Microsoft.Network/virtualNetworks/apimcus/subnets/tenant",
 *         },
 *         VirtualNetworkType = "External",
 *         Zones = new[]
 *         {
 *             "1",
 *             "2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			Location:          pulumi.String("East US 2 EUAP"),
 * 			PublicIpAddressId: pulumi.String("/subscriptions/subid/resourceGroups/rgName/providers/Microsoft.Network/publicIPAddresses/apimazvnet"),
 * 			PublisherEmail:    pulumi.String("apim@autorestsdk.com"),
 * 			PublisherName:     pulumi.String("autorestsdk"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("Premium"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 				"tag3": pulumi.String("value3"),
 * 			},
 * 			VirtualNetworkConfiguration: &apimanagement.VirtualNetworkConfigurationArgs{
 * 				SubnetResourceId: pulumi.String("/subscriptions/subid/resourceGroups/rgName/providers/Microsoft.Network/virtualNetworks/apimcus/subnets/tenant"),
 * 			},
 * 			VirtualNetworkType: pulumi.String("External"),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .location("East US 2 EUAP")
 *             .publicIpAddressId("/subscriptions/subid/resourceGroups/rgName/providers/Microsoft.Network/publicIPAddresses/apimazvnet")
 *             .publisherEmail("apim@autorestsdk.com")
 *             .publisherName("autorestsdk")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("name", "Premium")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2"),
 *                 Map.entry("tag3", "value3")
 *             ))
 *             .virtualNetworkConfiguration(Map.of("subnetResourceId", "/subscriptions/subid/resourceGroups/rgName/providers/Microsoft.Network/virtualNetworks/apimcus/subnets/tenant"))
 *             .virtualNetworkType("External")
 *             .zones(
 *                 "1",
 *                 "2")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateServiceInZones
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         Location = "North europe",
 *         PublisherEmail = "apim@autorestsdk.com",
 *         PublisherName = "autorestsdk",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 2,
 *             Name = "Premium",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *             { "tag3", "value3" },
 *         },
 *         Zones = new[]
 *         {
 *             "1",
 *             "2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			Location:          pulumi.String("North europe"),
 * 			PublisherEmail:    pulumi.String("apim@autorestsdk.com"),
 * 			PublisherName:     pulumi.String("autorestsdk"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("Premium"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 				"tag3": pulumi.String("value3"),
 * 			},
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .location("North europe")
 *             .publisherEmail("apim@autorestsdk.com")
 *             .publisherName("autorestsdk")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("name", "Premium")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2"),
 *                 Map.entry("tag3", "value3")
 *             ))
 *             .zones(
 *                 "1",
 *                 "2")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateServiceWithCustomHostnameKeyVault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         ApiVersionConstraint = new AzureNative.ApiManagement.Inputs.ApiVersionConstraintArgs
 *         {
 *             MinApiVersion = "2019-01-01",
 *         },
 *         HostnameConfigurations = new[]
 *         {
 *             new AzureNative.ApiManagement.Inputs.HostnameConfigurationArgs
 *             {
 *                 DefaultSslBinding = true,
 *                 HostName = "gateway1.msitesting.net",
 *                 IdentityClientId = "329419bc-adec-4dce-9568-25a6d486e468",
 *                 KeyVaultId = "https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert",
 *                 Type = "Proxy",
 *             },
 *             new AzureNative.ApiManagement.Inputs.HostnameConfigurationArgs
 *             {
 *                 HostName = "mgmt.msitesting.net",
 *                 IdentityClientId = "329419bc-adec-4dce-9568-25a6d486e468",
 *                 KeyVaultId = "https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert",
 *                 Type = "Management",
 *             },
 *             new AzureNative.ApiManagement.Inputs.HostnameConfigurationArgs
 *             {
 *                 HostName = "portal1.msitesting.net",
 *                 IdentityClientId = "329419bc-adec-4dce-9568-25a6d486e468",
 *                 KeyVaultId = "https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert",
 *                 Type = "Portal",
 *             },
 *         },
 *         Identity = new AzureNative.ApiManagement.Inputs.ApiManagementServiceIdentityArgs
 *         {
 *             Type = "UserAssigned",
 *             UserAssignedIdentities =
 *             {
 *                 { "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1", null },
 *             },
 *         },
 *         Location = "North Europe",
 *         PublisherEmail = "apim@autorestsdk.com",
 *         PublisherName = "autorestsdk",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 1,
 *             Name = "Premium",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *             { "tag3", "value3" },
 *         },
 *         VirtualNetworkType = "None",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			ApiVersionConstraint: &apimanagement.ApiVersionConstraintArgs{
 * 				MinApiVersion: pulumi.String("2019-01-01"),
 * 			},
 * 			HostnameConfigurations: []apimanagement.HostnameConfigurationArgs{
 * 				{
 * 					DefaultSslBinding: pulumi.Bool(true),
 * 					HostName:          pulumi.String("gateway1.msitesting.net"),
 * 					IdentityClientId:  pulumi.String("329419bc-adec-4dce-9568-25a6d486e468"),
 * 					KeyVaultId:        pulumi.String("https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert"),
 * 					Type:              pulumi.String("Proxy"),
 * 				},
 * 				{
 * 					HostName:         pulumi.String("mgmt.msitesting.net"),
 * 					IdentityClientId: pulumi.String("329419bc-adec-4dce-9568-25a6d486e468"),
 * 					KeyVaultId:       pulumi.String("https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert"),
 * 					Type:             pulumi.String("Management"),
 * 				},
 * 				{
 * 					HostName:         pulumi.String("portal1.msitesting.net"),
 * 					IdentityClientId: pulumi.String("329419bc-adec-4dce-9568-25a6d486e468"),
 * 					KeyVaultId:       pulumi.String("https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert"),
 * 					Type:             pulumi.String("Portal"),
 * 				},
 * 			},
 * 			Identity: apimanagement.ApiManagementServiceIdentityResponse{
 * 				Type: pulumi.String("UserAssigned"),
 * 				UserAssignedIdentities: apimanagement.UserIdentityPropertiesMap{
 * 					"/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": nil,
 * 				},
 * 			},
 * 			Location:          pulumi.String("North Europe"),
 * 			PublisherEmail:    pulumi.String("apim@autorestsdk.com"),
 * 			PublisherName:     pulumi.String("autorestsdk"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("Premium"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 				"tag3": pulumi.String("value3"),
 * 			},
 * 			VirtualNetworkType: pulumi.String("None"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .apiVersionConstraint(Map.of("minApiVersion", "2019-01-01"))
 *             .hostnameConfigurations(
 *                 Map.ofEntries(
 *                     Map.entry("defaultSslBinding", true),
 *                     Map.entry("hostName", "gateway1.msitesting.net"),
 *                     Map.entry("identityClientId", "329419bc-adec-4dce-9568-25a6d486e468"),
 *                     Map.entry("keyVaultId", "https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert"),
 *                     Map.entry("type", "Proxy")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("hostName", "mgmt.msitesting.net"),
 *                     Map.entry("identityClientId", "329419bc-adec-4dce-9568-25a6d486e468"),
 *                     Map.entry("keyVaultId", "https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert"),
 *                     Map.entry("type", "Management")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("hostName", "portal1.msitesting.net"),
 *                     Map.entry("identityClientId", "329419bc-adec-4dce-9568-25a6d486e468"),
 *                     Map.entry("keyVaultId", "https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert"),
 *                     Map.entry("type", "Portal")
 *                 ))
 *             .identity(Map.ofEntries(
 *                 Map.entry("type", "UserAssigned"),
 *                 Map.entry("userAssignedIdentities", Map.of("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1", ))
 *             ))
 *             .location("North Europe")
 *             .publisherEmail("apim@autorestsdk.com")
 *             .publisherName("autorestsdk")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("name", "Premium")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2"),
 *                 Map.entry("tag3", "value3")
 *             ))
 *             .virtualNetworkType("None")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateServiceWithNatGatewayEnabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         Location = "East US",
 *         NatGatewayState = "Enabled",
 *         PublisherEmail = "apim@autorestsdk.com",
 *         PublisherName = "autorestsdk",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 1,
 *             Name = "Premium",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *             { "tag3", "value3" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			Location:          pulumi.String("East US"),
 * 			NatGatewayState:   pulumi.String("Enabled"),
 * 			PublisherEmail:    pulumi.String("apim@autorestsdk.com"),
 * 			PublisherName:     pulumi.String("autorestsdk"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("Premium"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 				"tag3": pulumi.String("value3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .location("East US")
 *             .natGatewayState("Enabled")
 *             .publisherEmail("apim@autorestsdk.com")
 *             .publisherName("autorestsdk")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("name", "Premium")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2"),
 *                 Map.entry("tag3", "value3")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateServiceWithSystemCertificates
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         Certificates = new[]
 *         {
 *             new AzureNative.ApiManagement.Inputs.CertificateConfigurationArgs
 *             {
 *                 CertificatePassword = "Password",
 *                 EncodedCertificate = "*******Base64 encoded Certificate******************",
 *                 StoreName = "CertificateAuthority",
 *             },
 *         },
 *         Location = "Central US",
 *         PublisherEmail = "apim@autorestsdk.com",
 *         PublisherName = "autorestsdk",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 1,
 *             Name = "Basic",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *             { "tag3", "value3" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			Certificates: []apimanagement.CertificateConfigurationArgs{
 * 				{
 * 					CertificatePassword: pulumi.String("Password"),
 * 					EncodedCertificate:  pulumi.String("*******Base64 encoded Certificate******************"),
 * 					StoreName:           pulumi.String("CertificateAuthority"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("Central US"),
 * 			PublisherEmail:    pulumi.String("apim@autorestsdk.com"),
 * 			PublisherName:     pulumi.String("autorestsdk"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("Basic"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 				"tag3": pulumi.String("value3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .certificates(Map.ofEntries(
 *                 Map.entry("certificatePassword", "Password"),
 *                 Map.entry("encodedCertificate", "*******Base64 encoded Certificate******************"),
 *                 Map.entry("storeName", "CertificateAuthority")
 *             ))
 *             .location("Central US")
 *             .publisherEmail("apim@autorestsdk.com")
 *             .publisherName("autorestsdk")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("name", "Basic")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2"),
 *                 Map.entry("tag3", "value3")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateServiceWithUserAssignedIdentity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         Identity = new AzureNative.ApiManagement.Inputs.ApiManagementServiceIdentityArgs
 *         {
 *             Type = "UserAssigned",
 *             UserAssignedIdentities =
 *             {
 *                 { "/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/apimService1", null },
 *             },
 *         },
 *         Location = "West US",
 *         PublisherEmail = "apim@autorestsdk.com",
 *         PublisherName = "autorestsdk",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 0,
 *             Name = "Consumption",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *             { "tag3", "value3" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			Identity: apimanagement.ApiManagementServiceIdentityResponse{
 * 				Type: pulumi.String("UserAssigned"),
 * 				UserAssignedIdentities: apimanagement.UserIdentityPropertiesMap{
 * 					"/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/apimService1": nil,
 * 				},
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			PublisherEmail:    pulumi.String("apim@autorestsdk.com"),
 * 			PublisherName:     pulumi.String("autorestsdk"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(0),
 * 				Name:     pulumi.String("Consumption"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 				"tag3": pulumi.String("value3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .identity(Map.ofEntries(
 *                 Map.entry("type", "UserAssigned"),
 *                 Map.entry("userAssignedIdentities", Map.of("/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/apimService1", ))
 *             ))
 *             .location("West US")
 *             .publisherEmail("apim@autorestsdk.com")
 *             .publisherName("autorestsdk")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 0),
 *                 Map.entry("name", "Consumption")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2"),
 *                 Map.entry("tag3", "value3")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementUndelete
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiManagementService = new AzureNative.ApiManagement.ApiManagementService("apiManagementService", new()
 *     {
 *         Location = "South Central US",
 *         PublisherEmail = "foo@contoso.com",
 *         PublisherName = "foo",
 *         ResourceGroupName = "rg1",
 *         Restore = true,
 *         ServiceName = "apimService1",
 *         Sku = new AzureNative.ApiManagement.Inputs.ApiManagementServiceSkuPropertiesArgs
 *         {
 *             Capacity = 1,
 *             Name = "Developer",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiManagementService(ctx, "apiManagementService", &apimanagement.ApiManagementServiceArgs{
 * 			Location:          pulumi.String("South Central US"),
 * 			PublisherEmail:    pulumi.String("foo@contoso.com"),
 * 			PublisherName:     pulumi.String("foo"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Restore:           pulumi.Bool(true),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sku: &apimanagement.ApiManagementServiceSkuPropertiesArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("Developer"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiManagementService;
 * import com.pulumi.azurenative.apimanagement.ApiManagementServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiManagementService = new ApiManagementService("apiManagementService", ApiManagementServiceArgs.builder()
 *             .location("South Central US")
 *             .publisherEmail("foo@contoso.com")
 *             .publisherName("foo")
 *             .resourceGroupName("rg1")
 *             .restore(true)
 *             .serviceName("apimService1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("name", "Developer")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiManagementService apimService1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}
 * ```
 */
public class ApiManagementService internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.ApiManagementService,
) : KotlinCustomResource(javaResource, ApiManagementServiceMapper) {
    /**
     * Additional datacenter locations of the API Management service.
     */
    public val additionalLocations: Output<List<AdditionalLocationResponse>>?
        get() = javaResource.additionalLocations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        additionalLocationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Control Plane Apis version constraint for the API Management service.
     */
    public val apiVersionConstraint: Output<ApiVersionConstraintResponse>?
        get() = javaResource.apiVersionConstraint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> apiVersionConstraintResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed is 10.
     */
    public val certificates: Output<List<CertificateConfigurationResponse>>?
        get() = javaResource.certificates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> certificateConfigurationResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Creation UTC date of the API Management service.The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     */
    public val createdAtUtc: Output<String>
        get() = javaResource.createdAtUtc().applyValue({ args0 -> args0 })

    /**
     * Custom properties of the API Management service.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168` will disable the cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11` can be used to disable just TLS 1.1.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10` can be used to disable TLS 1.0 on an API Management service.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11` can be used to disable just TLS 1.1 for communications with backends.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10` can be used to disable TLS 1.0 for communications with backends.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2` can be used to enable HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on PATCH operation will reset omitted properties' values to their defaults. For all the settings except Http2 the default value is `True` if the service was created on or before April 1, 2018 and `False` otherwise. Http2 setting's default value is `False`.</br></br>You can disable any of the following ciphers by using settings `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`: TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256, TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA. For example, `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:`false`. The default value is `true` for them.</br> Note: The following ciphers can't be disabled since they are required by internal platform components: TLS_AES_256_GCM_SHA384,TLS_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256
     */
    public val customProperties: Output<Map<String, String>>?
        get() = javaResource.customProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * DEveloper Portal endpoint URL of the API Management service.
     */
    public val developerPortalUrl: Output<String>
        get() = javaResource.developerPortalUrl().applyValue({ args0 -> args0 })

    /**
     * Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway in master region.
     */
    public val disableGateway: Output<Boolean>?
        get() = javaResource.disableGateway().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Property only meant to be used for Consumption SKU Service. This enforces a client certificate to be presented on each request to the gateway. This also enables the ability to authenticate the certificate in the policy on the gateway.
     */
    public val enableClientCertificate: Output<Boolean>?
        get() = javaResource.enableClientCertificate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ETag of the resource.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Gateway URL of the API Management service in the Default Region.
     */
    public val gatewayRegionalUrl: Output<String>
        get() = javaResource.gatewayRegionalUrl().applyValue({ args0 -> args0 })

    /**
     * Gateway URL of the API Management service.
     */
    public val gatewayUrl: Output<String>
        get() = javaResource.gatewayUrl().applyValue({ args0 -> args0 })

    /**
     * Custom hostname configuration of the API Management service.
     */
    public val hostnameConfigurations: Output<List<HostnameConfigurationResponse>>?
        get() = javaResource.hostnameConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        hostnameConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Managed service identity of the Api Management service.
     */
    public val identity: Output<ApiManagementServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    apiManagementServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Management API endpoint URL of the API Management service.
     */
    public val managementApiUrl: Output<String>
        get() = javaResource.managementApiUrl().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Property can be used to enable NAT Gateway for this API Management service.
     */
    public val natGatewayState: Output<String>?
        get() = javaResource.natGatewayState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Email address from which the notification will be sent.
     */
    public val notificationSenderEmail: Output<String>?
        get() = javaResource.notificationSenderEmail().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Outbound public IPV4 address prefixes associated with NAT Gateway deployed service. Available only for Premium SKU on stv2 platform.
     */
    public val outboundPublicIPAddresses: Output<List<String>>
        get() = javaResource.outboundPublicIPAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Compute Platform Version running the service in this location.
     */
    public val platformVersion: Output<String>
        get() = javaResource.platformVersion().applyValue({ args0 -> args0 })

    /**
     * Publisher portal endpoint Url of the API Management service.
     */
    public val portalUrl: Output<String>
        get() = javaResource.portalUrl().applyValue({ args0 -> args0 })

    /**
     * List of Private Endpoint Connections of this service.
     */
    public val privateEndpointConnections:
        Output<List<RemotePrivateEndpointConnectionWrapperResponse>>?
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        remotePrivateEndpointConnectionWrapperResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Private Static Load Balanced IP addresses of the API Management service in Primary region which is deployed in an Internal Virtual Network. Available only for Basic, Standard, Premium and Isolated SKU.
     */
    public val privateIPAddresses: Output<List<String>>
        get() = javaResource.privateIPAddresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The current provisioning state of the API Management service which can be one of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Public Static Load Balanced IP addresses of the API Management service in Primary region. Available only for Basic, Standard, Premium and Isolated SKU.
     */
    public val publicIPAddresses: Output<List<String>>
        get() = javaResource.publicIPAddresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the region. Supported only for Developer and Premium SKU being deployed in Virtual Network.
     */
    public val publicIpAddressId: Output<String>?
        get() = javaResource.publicIpAddressId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether or not public endpoint access is allowed for this API Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Publisher email.
     */
    public val publisherEmail: Output<String>
        get() = javaResource.publisherEmail().applyValue({ args0 -> args0 })

    /**
     * Publisher name.
     */
    public val publisherName: Output<String>
        get() = javaResource.publisherName().applyValue({ args0 -> args0 })

    /**
     * Undelete Api Management Service if it was previously soft-deleted. If this flag is specified and set to True all other properties will be ignored.
     */
    public val restore: Output<Boolean>?
        get() = javaResource.restore().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * SCM endpoint URL of the API Management service.
     */
    public val scmUrl: Output<String>
        get() = javaResource.scmUrl().applyValue({ args0 -> args0 })

    /**
     * SKU properties of the API Management service.
     */
    public val sku: Output<ApiManagementServiceSkuPropertiesResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                apiManagementServiceSkuPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The provisioning state of the API Management service, which is targeted by the long running operation started on the service.
     */
    public val targetProvisioningState: Output<String>
        get() = javaResource.targetProvisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource type for API Management resource is set to Microsoft.ApiManagement.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Virtual network configuration of the API Management service.
     */
    public val virtualNetworkConfiguration: Output<VirtualNetworkConfigurationResponse>?
        get() = javaResource.virtualNetworkConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> virtualNetworkConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management service is not part of any Virtual Network, External means the API Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside a Virtual Network having an Intranet Facing Endpoint only.
     */
    public val virtualNetworkType: Output<String>?
        get() = javaResource.virtualNetworkType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of availability zones denoting where the resource needs to come from.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object ApiManagementServiceMapper : ResourceMapper<ApiManagementService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.ApiManagementService::class == javaResource::class

    override fun map(javaResource: Resource): ApiManagementService = ApiManagementService(
        javaResource
            as com.pulumi.azurenative.apimanagement.ApiManagementService,
    )
}

/**
 * @see [ApiManagementService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiManagementService].
 */
public suspend fun apiManagementService(
    name: String,
    block: suspend ApiManagementServiceResourceBuilder.() -> Unit,
): ApiManagementService {
    val builder = ApiManagementServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiManagementService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiManagementService(name: String): ApiManagementService {
    val builder = ApiManagementServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
