@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApiPolicy].
 */
@PulumiTagMarker
public class ApiPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiPolicyArgs = ApiPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiPolicyArgsBuilder.() -> Unit) {
        val builder = ApiPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ApiPolicy {
        val builtJavaResource = com.pulumi.azurenative.apimanagement.ApiPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApiPolicy(builtJavaResource)
    }
}

/**
 * Policy Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-10-10, 2018-06-01-preview, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiPolicy = new AzureNative.ApiManagement.ApiPolicy("apiPolicy", new()
 *     {
 *         ApiId = "5600b57e7e8880006a040001",
 *         Format = "xml",
 *         PolicyId = "policy",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = "<policies> <inbound /> <backend>    <forward-request />  </backend>  <outbound /></policies>",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiPolicy(ctx, "apiPolicy", &apimanagement.ApiPolicyArgs{
 * 			ApiId:             pulumi.String("5600b57e7e8880006a040001"),
 * 			Format:            pulumi.String("xml"),
 * 			PolicyId:          pulumi.String("policy"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value:             pulumi.String("<policies> <inbound /> <backend>    <forward-request />  </backend>  <outbound /></policies>"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiPolicy;
 * import com.pulumi.azurenative.apimanagement.ApiPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiPolicy = new ApiPolicy("apiPolicy", ApiPolicyArgs.builder()
 *             .apiId("5600b57e7e8880006a040001")
 *             .format("xml")
 *             .policyId("policy")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("<policies> <inbound /> <backend>    <forward-request />  </backend>  <outbound /></policies>")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateApiPolicyNonXmlEncoded
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiPolicy = new AzureNative.ApiManagement.ApiPolicy("apiPolicy", new()
 *     {
 *         ApiId = "5600b57e7e8880006a040001",
 *         Format = "rawxml",
 *         PolicyId = "policy",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = @"<policies>
 *      <inbound>
 *      <base />
 *   <set-header name=""newvalue"" exists-action=""override"">
 *    <value>""@(context.Request.Headers.FirstOrDefault(h => h.Ke==""Via""))"" </value>
 *     </set-header>
 *   </inbound>
 *       </policies>",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiPolicy(ctx, "apiPolicy", &apimanagement.ApiPolicyArgs{
 * 			ApiId:             pulumi.String("5600b57e7e8880006a040001"),
 * 			Format:            pulumi.String("rawxml"),
 * 			PolicyId:          pulumi.String("policy"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value: pulumi.String(`<policies>
 *      <inbound>
 *      <base />
 *   <set-header name="newvalue" exists-action="override">
 *    <value>"@(context.Request.Headers.FirstOrDefault(h => h.Ke=="Via"))" </value>
 *     </set-header>
 *   </inbound>
 *       </policies>`),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiPolicy;
 * import com.pulumi.azurenative.apimanagement.ApiPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiPolicy = new ApiPolicy("apiPolicy", ApiPolicyArgs.builder()
 *             .apiId("5600b57e7e8880006a040001")
 *             .format("rawxml")
 *             .policyId("policy")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("""
 * <policies>
 *      <inbound>
 *      <base />
 *   <set-header name="newvalue" exists-action="override">
 *    <value>"@(context.Request.Headers.FirstOrDefault(h => h.Ke=="Via"))" </value>
 *     </set-header>
 *   </inbound>
 *       </policies>            """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiPolicy policy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/policies/{policyId}
 * ```
 */
public class ApiPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.ApiPolicy,
) : KotlinCustomResource(javaResource, ApiPolicyMapper) {
    /**
     * Format of the policyContent.
     */
    public val format: Output<String>?
        get() = javaResource.format().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Contents of the Policy as defined by the format.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object ApiPolicyMapper : ResourceMapper<ApiPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.ApiPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ApiPolicy = ApiPolicy(
        javaResource as
            com.pulumi.azurenative.apimanagement.ApiPolicy,
    )
}

/**
 * @see [ApiPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiPolicy].
 */
public suspend fun apiPolicy(name: String, block: suspend ApiPolicyResourceBuilder.() -> Unit):
    ApiPolicy {
    val builder = ApiPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiPolicy(name: String): ApiPolicy {
    val builder = ApiPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
