@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ApiTagDescriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2019-01-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiTagDescription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiTagDescription = new AzureNative.ApiManagement.ApiTagDescription("apiTagDescription", new()
 *     {
 *         ApiId = "5931a75ae4bbd512a88c680b",
 *         Description = "Some description that will be displayed for operation's tag if the tag is assigned to operation of the API",
 *         ExternalDocsDescription = "Description of the external docs resource",
 *         ExternalDocsUrl = "http://some.url/additionaldoc",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         TagDescriptionId = "tagId1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiTagDescription(ctx, "apiTagDescription", &apimanagement.ApiTagDescriptionArgs{
 * 			ApiId:                   pulumi.String("5931a75ae4bbd512a88c680b"),
 * 			Description:             pulumi.String("Some description that will be displayed for operation's tag if the tag is assigned to operation of the API"),
 * 			ExternalDocsDescription: pulumi.String("Description of the external docs resource"),
 * 			ExternalDocsUrl:         pulumi.String("http://some.url/additionaldoc"),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 			ServiceName:             pulumi.String("apimService1"),
 * 			TagDescriptionId:        pulumi.String("tagId1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiTagDescription;
 * import com.pulumi.azurenative.apimanagement.ApiTagDescriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiTagDescription = new ApiTagDescription("apiTagDescription", ApiTagDescriptionArgs.builder()
 *             .apiId("5931a75ae4bbd512a88c680b")
 *             .description("Some description that will be displayed for operation's tag if the tag is assigned to operation of the API")
 *             .externalDocsDescription("Description of the external docs resource")
 *             .externalDocsUrl("http://some.url/additionaldoc")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .tagDescriptionId("tagId1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiTagDescription tagId1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/tagDescriptions/{tagDescriptionId}
 * ```
 * @property apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
 * @property description Description of the Tag.
 * @property externalDocsDescription Description of the external resources describing the tag.
 * @property externalDocsUrl Absolute URL of external resources describing the tag.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property tagDescriptionId Tag description identifier. Used when creating tagDescription for API/Tag association. Based on API and Tag names.
 */
public data class ApiTagDescriptionArgs(
    public val apiId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val externalDocsDescription: Output<String>? = null,
    public val externalDocsUrl: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val tagDescriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.ApiTagDescriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.ApiTagDescriptionArgs =
        com.pulumi.azurenative.apimanagement.ApiTagDescriptionArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .externalDocsDescription(externalDocsDescription?.applyValue({ args0 -> args0 }))
            .externalDocsUrl(externalDocsUrl?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .tagDescriptionId(tagDescriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiTagDescriptionArgs].
 */
@PulumiTagMarker
public class ApiTagDescriptionArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var description: Output<String>? = null

    private var externalDocsDescription: Output<String>? = null

    private var externalDocsUrl: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var tagDescriptionId: Output<String>? = null

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("oiybwydbmmccxonh")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Description of the Tag.
     */
    @JvmName("kkwiycuuxyktmcac")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Description of the external resources describing the tag.
     */
    @JvmName("ebfgxedrrqmbkwii")
    public suspend fun externalDocsDescription(`value`: Output<String>) {
        this.externalDocsDescription = value
    }

    /**
     * @param value Absolute URL of external resources describing the tag.
     */
    @JvmName("iopnhmrrtenunkre")
    public suspend fun externalDocsUrl(`value`: Output<String>) {
        this.externalDocsUrl = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sjluheyacrirtkcx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("mgkmdiywlekrlhac")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Tag description identifier. Used when creating tagDescription for API/Tag association. Based on API and Tag names.
     */
    @JvmName("pwpukpgabnixhipa")
    public suspend fun tagDescriptionId(`value`: Output<String>) {
        this.tagDescriptionId = value
    }

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("kxljlejlujkjkpef")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Description of the Tag.
     */
    @JvmName("jmqlcahrhkqtlccj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Description of the external resources describing the tag.
     */
    @JvmName("iejjgsngsltwdgan")
    public suspend fun externalDocsDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalDocsDescription = mapped
    }

    /**
     * @param value Absolute URL of external resources describing the tag.
     */
    @JvmName("axatwuaisifnafop")
    public suspend fun externalDocsUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalDocsUrl = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("whfoyeuecjqotpgw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("luhkaustacoenipl")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Tag description identifier. Used when creating tagDescription for API/Tag association. Based on API and Tag names.
     */
    @JvmName("tubwmpvsjebyuawp")
    public suspend fun tagDescriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagDescriptionId = mapped
    }

    internal fun build(): ApiTagDescriptionArgs = ApiTagDescriptionArgs(
        apiId = apiId,
        description = description,
        externalDocsDescription = externalDocsDescription,
        externalDocsUrl = externalDocsUrl,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        tagDescriptionId = tagDescriptionId,
    )
}
