@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApiVersionSet].
 */
@PulumiTagMarker
public class ApiVersionSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiVersionSetArgs = ApiVersionSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiVersionSetArgsBuilder.() -> Unit) {
        val builder = ApiVersionSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ApiVersionSet {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.ApiVersionSet(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApiVersionSet(builtJavaResource)
    }
}

/**
 * API Version Set Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiVersionSet
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiVersionSet = new AzureNative.ApiManagement.ApiVersionSet("apiVersionSet", new()
 *     {
 *         Description = "Version configuration",
 *         DisplayName = "api set 1",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         VersionSetId = "api1",
 *         VersioningScheme = "Segment",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiVersionSet(ctx, "apiVersionSet", &apimanagement.ApiVersionSetArgs{
 * 			Description:       pulumi.String("Version configuration"),
 * 			DisplayName:       pulumi.String("api set 1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			VersionSetId:      pulumi.String("api1"),
 * 			VersioningScheme:  pulumi.String("Segment"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiVersionSet;
 * import com.pulumi.azurenative.apimanagement.ApiVersionSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiVersionSet = new ApiVersionSet("apiVersionSet", ApiVersionSetArgs.builder()
 *             .description("Version configuration")
 *             .displayName("api set 1")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .versionSetId("api1")
 *             .versioningScheme("Segment")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiVersionSet api1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apiVersionSets/{versionSetId}
 * ```
 */
public class ApiVersionSet internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.ApiVersionSet,
) : KotlinCustomResource(javaResource, ApiVersionSetMapper) {
    /**
     * Description of API Version Set.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of API Version Set
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
     */
    public val versionHeaderName: Output<String>?
        get() = javaResource.versionHeaderName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
     */
    public val versionQueryName: Output<String>?
        get() = javaResource.versionQueryName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An value that determines where the API Version identifier will be located in a HTTP request.
     */
    public val versioningScheme: Output<String>
        get() = javaResource.versioningScheme().applyValue({ args0 -> args0 })
}

public object ApiVersionSetMapper : ResourceMapper<ApiVersionSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.ApiVersionSet::class == javaResource::class

    override fun map(javaResource: Resource): ApiVersionSet = ApiVersionSet(
        javaResource as
            com.pulumi.azurenative.apimanagement.ApiVersionSet,
    )
}

/**
 * @see [ApiVersionSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiVersionSet].
 */
public suspend fun apiVersionSet(
    name: String,
    block: suspend ApiVersionSetResourceBuilder.() -> Unit,
): ApiVersionSet {
    val builder = ApiVersionSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiVersionSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiVersionSet(name: String): ApiVersionSet {
    val builder = ApiVersionSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
