@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.kotlin.outputs.WikiDocumentationContractResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.WikiDocumentationContractResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ApiWiki].
 */
@PulumiTagMarker
public class ApiWikiResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiWikiArgs = ApiWikiArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiWikiArgsBuilder.() -> Unit) {
        val builder = ApiWikiArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ApiWiki {
        val builtJavaResource = com.pulumi.azurenative.apimanagement.ApiWiki(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApiWiki(builtJavaResource)
    }
}

/**
 * Wiki properties
 * Azure REST API version: 2022-08-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiWiki
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiWiki = new AzureNative.ApiManagement.ApiWiki("apiWiki", new()
 *     {
 *         ApiId = "57d1f7558aa04f15146d9d8a",
 *         Documents = new[]
 *         {
 *             new AzureNative.ApiManagement.Inputs.WikiDocumentationContractArgs
 *             {
 *                 DocumentationId = "docId1",
 *             },
 *             new AzureNative.ApiManagement.Inputs.WikiDocumentationContractArgs
 *             {
 *                 DocumentationId = "docId2",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiWiki(ctx, "apiWiki", &apimanagement.ApiWikiArgs{
 * 			ApiId: pulumi.String("57d1f7558aa04f15146d9d8a"),
 * 			Documents: []apimanagement.WikiDocumentationContractArgs{
 * 				{
 * 					DocumentationId: pulumi.String("docId1"),
 * 				},
 * 				{
 * 					DocumentationId: pulumi.String("docId2"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiWiki;
 * import com.pulumi.azurenative.apimanagement.ApiWikiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiWiki = new ApiWiki("apiWiki", ApiWikiArgs.builder()
 *             .apiId("57d1f7558aa04f15146d9d8a")
 *             .documents(
 *                 Map.of("documentationId", "docId1"),
 *                 Map.of("documentationId", "docId2"))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiWiki default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/wikis/default
 * ```
 */
public class ApiWiki internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.ApiWiki,
) : KotlinCustomResource(javaResource, ApiWikiMapper) {
    /**
     * Collection wiki documents included into this wiki.
     */
    public val documents: Output<List<WikiDocumentationContractResponse>>?
        get() = javaResource.documents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApiWikiMapper : ResourceMapper<ApiWiki> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.ApiWiki::class == javaResource::class

    override fun map(javaResource: Resource): ApiWiki = ApiWiki(
        javaResource as
            com.pulumi.azurenative.apimanagement.ApiWiki,
    )
}

/**
 * @see [ApiWiki].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiWiki].
 */
public suspend fun apiWiki(name: String, block: suspend ApiWikiResourceBuilder.() -> Unit):
    ApiWiki {
    val builder = ApiWikiResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiWiki].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiWiki(name: String): ApiWiki {
    val builder = ApiWikiResourceBuilder()
    builder.name(name)
    return builder.build()
}
