@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.kotlin.outputs.AuthorizationErrorResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.AuthorizationErrorResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Authorization].
 */
@PulumiTagMarker
public class AuthorizationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AuthorizationArgs = AuthorizationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AuthorizationArgsBuilder.() -> Unit) {
        val builder = AuthorizationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Authorization {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.Authorization(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Authorization(builtJavaResource)
    }
}

/**
 * Authorization contract.
 * Azure REST API version: 2022-08-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateAuthorizationAADAuthCode
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authorization = new AzureNative.ApiManagement.Authorization("authorization", new()
 *     {
 *         AuthorizationId = "authz2",
 *         AuthorizationProviderId = "aadwithauthcode",
 *         AuthorizationType = "OAuth2",
 *         OAuth2GrantType = "AuthorizationCode",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewAuthorization(ctx, "authorization", &apimanagement.AuthorizationArgs{
 * 			AuthorizationId:         pulumi.String("authz2"),
 * 			AuthorizationProviderId: pulumi.String("aadwithauthcode"),
 * 			AuthorizationType:       pulumi.String("OAuth2"),
 * 			OAuth2GrantType:         pulumi.String("AuthorizationCode"),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 			ServiceName:             pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Authorization;
 * import com.pulumi.azurenative.apimanagement.AuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authorization = new Authorization("authorization", AuthorizationArgs.builder()
 *             .authorizationId("authz2")
 *             .authorizationProviderId("aadwithauthcode")
 *             .authorizationType("OAuth2")
 *             .oAuth2GrantType("AuthorizationCode")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateAuthorizationAADClientCred
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authorization = new AzureNative.ApiManagement.Authorization("authorization", new()
 *     {
 *         AuthorizationId = "authz1",
 *         AuthorizationProviderId = "aadwithclientcred",
 *         AuthorizationType = "OAuth2",
 *         OAuth2GrantType = "AuthorizationCode",
 *         Parameters =
 *         {
 *             { "clientId", "53790925-fdd3-4b80-bc7a-4c3aaf25801d" },
 *             { "clientSecret", "FcJkQ3iPSaKAQRA7Ft8Q~fZ1X5vKmqzUAfJagcJ8" },
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewAuthorization(ctx, "authorization", &apimanagement.AuthorizationArgs{
 * 			AuthorizationId:         pulumi.String("authz1"),
 * 			AuthorizationProviderId: pulumi.String("aadwithclientcred"),
 * 			AuthorizationType:       pulumi.String("OAuth2"),
 * 			OAuth2GrantType:         pulumi.String("AuthorizationCode"),
 * 			Parameters: pulumi.StringMap{
 * 				"clientId":     pulumi.String("53790925-fdd3-4b80-bc7a-4c3aaf25801d"),
 * 				"clientSecret": pulumi.String("FcJkQ3iPSaKAQRA7Ft8Q~fZ1X5vKmqzUAfJagcJ8"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Authorization;
 * import com.pulumi.azurenative.apimanagement.AuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authorization = new Authorization("authorization", AuthorizationArgs.builder()
 *             .authorizationId("authz1")
 *             .authorizationProviderId("aadwithclientcred")
 *             .authorizationType("OAuth2")
 *             .oAuth2GrantType("AuthorizationCode")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("clientId", "53790925-fdd3-4b80-bc7a-4c3aaf25801d"),
 *                 Map.entry("clientSecret", "FcJkQ3iPSaKAQRA7Ft8Q~fZ1X5vKmqzUAfJagcJ8")
 *             ))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Authorization authz1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}
 * ```
 */
public class Authorization internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.Authorization,
) : KotlinCustomResource(javaResource, AuthorizationMapper) {
    /**
     * Authorization type options
     */
    public val authorizationType: Output<String>?
        get() = javaResource.authorizationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Authorization error details.
     */
    public val error: Output<AuthorizationErrorResponse>?
        get() = javaResource.error().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * OAuth2 grant type options
     */
    public val oAuth2GrantType: Output<String>?
        get() = javaResource.oAuth2GrantType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Authorization parameters
     */
    public val parameters: Output<Map<String, String>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Status of the Authorization
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AuthorizationMapper : ResourceMapper<Authorization> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.Authorization::class == javaResource::class

    override fun map(javaResource: Resource): Authorization = Authorization(
        javaResource as
            com.pulumi.azurenative.apimanagement.Authorization,
    )
}

/**
 * @see [Authorization].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Authorization].
 */
public suspend fun authorization(
    name: String,
    block: suspend AuthorizationResourceBuilder.() -> Unit,
): Authorization {
    val builder = AuthorizationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Authorization].
 * @param name The _unique_ name of the resulting resource.
 */
public fun authorization(name: String): Authorization {
    val builder = AuthorizationResourceBuilder()
    builder.name(name)
    return builder.build()
}
