@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.AuthorizationAccessPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Authorization access policy contract.
 * Azure REST API version: 2022-08-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateAuthorizationAccessPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authorizationAccessPolicy = new AzureNative.ApiManagement.AuthorizationAccessPolicy("authorizationAccessPolicy", new()
 *     {
 *         AuthorizationAccessPolicyId = "fe0bed83-631f-4149-bd0b-0464b1bc7cab",
 *         AuthorizationId = "authz1",
 *         AuthorizationProviderId = "aadwithauthcode",
 *         ObjectId = "fe0bed83-631f-4149-bd0b-0464b1bc7cab",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         TenantId = "13932a0d-5c63-4d37-901d-1df9c97722ff",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewAuthorizationAccessPolicy(ctx, "authorizationAccessPolicy", &apimanagement.AuthorizationAccessPolicyArgs{
 * 			AuthorizationAccessPolicyId: pulumi.String("fe0bed83-631f-4149-bd0b-0464b1bc7cab"),
 * 			AuthorizationId:             pulumi.String("authz1"),
 * 			AuthorizationProviderId:     pulumi.String("aadwithauthcode"),
 * 			ObjectId:                    pulumi.String("fe0bed83-631f-4149-bd0b-0464b1bc7cab"),
 * 			ResourceGroupName:           pulumi.String("rg1"),
 * 			ServiceName:                 pulumi.String("apimService1"),
 * 			TenantId:                    pulumi.String("13932a0d-5c63-4d37-901d-1df9c97722ff"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.AuthorizationAccessPolicy;
 * import com.pulumi.azurenative.apimanagement.AuthorizationAccessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authorizationAccessPolicy = new AuthorizationAccessPolicy("authorizationAccessPolicy", AuthorizationAccessPolicyArgs.builder()
 *             .authorizationAccessPolicyId("fe0bed83-631f-4149-bd0b-0464b1bc7cab")
 *             .authorizationId("authz1")
 *             .authorizationProviderId("aadwithauthcode")
 *             .objectId("fe0bed83-631f-4149-bd0b-0464b1bc7cab")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .tenantId("13932a0d-5c63-4d37-901d-1df9c97722ff")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:AuthorizationAccessPolicy fe0bed83-631f-4149-bd0b-0464b1bc7cab /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies/{authorizationAccessPolicyId}
 * ```
 * @property authorizationAccessPolicyId Identifier of the authorization access policy.
 * @property authorizationId Identifier of the authorization.
 * @property authorizationProviderId Identifier of the authorization provider.
 * @property objectId The Object Id
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property tenantId The Tenant Id
 */
public data class AuthorizationAccessPolicyArgs(
    public val authorizationAccessPolicyId: Output<String>? = null,
    public val authorizationId: Output<String>? = null,
    public val authorizationProviderId: Output<String>? = null,
    public val objectId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.AuthorizationAccessPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.AuthorizationAccessPolicyArgs =
        com.pulumi.azurenative.apimanagement.AuthorizationAccessPolicyArgs.builder()
            .authorizationAccessPolicyId(authorizationAccessPolicyId?.applyValue({ args0 -> args0 }))
            .authorizationId(authorizationId?.applyValue({ args0 -> args0 }))
            .authorizationProviderId(authorizationProviderId?.applyValue({ args0 -> args0 }))
            .objectId(objectId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthorizationAccessPolicyArgs].
 */
@PulumiTagMarker
public class AuthorizationAccessPolicyArgsBuilder internal constructor() {
    private var authorizationAccessPolicyId: Output<String>? = null

    private var authorizationId: Output<String>? = null

    private var authorizationProviderId: Output<String>? = null

    private var objectId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Identifier of the authorization access policy.
     */
    @JvmName("ultpuxjdvpywkbgl")
    public suspend fun authorizationAccessPolicyId(`value`: Output<String>) {
        this.authorizationAccessPolicyId = value
    }

    /**
     * @param value Identifier of the authorization.
     */
    @JvmName("vxeufuvtgjuvcqgt")
    public suspend fun authorizationId(`value`: Output<String>) {
        this.authorizationId = value
    }

    /**
     * @param value Identifier of the authorization provider.
     */
    @JvmName("beymprytwgrwdrnk")
    public suspend fun authorizationProviderId(`value`: Output<String>) {
        this.authorizationProviderId = value
    }

    /**
     * @param value The Object Id
     */
    @JvmName("usljqylkpqhgtduq")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("idaeireiswekonvh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("tmjkrcjinhepsaso")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The Tenant Id
     */
    @JvmName("rccackuwbyquuewh")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Identifier of the authorization access policy.
     */
    @JvmName("ljwnrclrgbykhank")
    public suspend fun authorizationAccessPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationAccessPolicyId = mapped
    }

    /**
     * @param value Identifier of the authorization.
     */
    @JvmName("purwduuupmgygqop")
    public suspend fun authorizationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationId = mapped
    }

    /**
     * @param value Identifier of the authorization provider.
     */
    @JvmName("mxoqpyffyixhmesl")
    public suspend fun authorizationProviderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationProviderId = mapped
    }

    /**
     * @param value The Object Id
     */
    @JvmName("whqiuxecxsgxdkrm")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yjsxnjivswnqlehc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("eajfhplemjqeulge")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value The Tenant Id
     */
    @JvmName("inbrpdemkatqykqv")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): AuthorizationAccessPolicyArgs = AuthorizationAccessPolicyArgs(
        authorizationAccessPolicyId = authorizationAccessPolicyId,
        authorizationId = authorizationId,
        authorizationProviderId = authorizationProviderId,
        objectId = objectId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        tenantId = tenantId,
    )
}
