@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.kotlin.outputs.EmailTemplateParametersContractPropertiesResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.EmailTemplateParametersContractPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [EmailTemplate].
 */
@PulumiTagMarker
public class EmailTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EmailTemplateArgs = EmailTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EmailTemplateArgsBuilder.() -> Unit) {
        val builder = EmailTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EmailTemplate {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.EmailTemplate(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EmailTemplate(builtJavaResource)
    }
}

/**
 * Email Template details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateTemplate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var emailTemplate = new AzureNative.ApiManagement.EmailTemplate("emailTemplate", new()
 *     {
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Subject = "Your request for $IssueName was successfully received.",
 *         TemplateName = "newIssueNotificationMessage",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewEmailTemplate(ctx, "emailTemplate", &apimanagement.EmailTemplateArgs{
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Subject:           pulumi.String("Your request for $IssueName was successfully received."),
 * 			TemplateName:      pulumi.String("newIssueNotificationMessage"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.EmailTemplate;
 * import com.pulumi.azurenative.apimanagement.EmailTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var emailTemplate = new EmailTemplate("emailTemplate", EmailTemplateArgs.builder()
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .subject("Your request for $IssueName was successfully received.")
 *             .templateName("newIssueNotificationMessage")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:EmailTemplate NewIssueNotificationMessage /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/templates/{templateName}
 * ```
 */
public class EmailTemplate internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.EmailTemplate,
) : KotlinCustomResource(javaResource, EmailTemplateMapper) {
    /**
     * Email Template Body. This should be a valid XDocument
     */
    public val body: Output<String>
        get() = javaResource.body().applyValue({ args0 -> args0 })

    /**
     * Description of the Email Template.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the template is the default template provided by API Management or has been edited.
     */
    public val isDefault: Output<Boolean>
        get() = javaResource.isDefault().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Email Template Parameter values.
     */
    public val parameters: Output<List<EmailTemplateParametersContractPropertiesResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Subject of the Template.
     */
    public val subject: Output<String>
        get() = javaResource.subject().applyValue({ args0 -> args0 })

    /**
     * Title of the Template.
     */
    public val title: Output<String>?
        get() = javaResource.title().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EmailTemplateMapper : ResourceMapper<EmailTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.EmailTemplate::class == javaResource::class

    override fun map(javaResource: Resource): EmailTemplate = EmailTemplate(
        javaResource as
            com.pulumi.azurenative.apimanagement.EmailTemplate,
    )
}

/**
 * @see [EmailTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EmailTemplate].
 */
public suspend fun emailTemplate(
    name: String,
    block: suspend EmailTemplateResourceBuilder.() -> Unit,
): EmailTemplate {
    val builder = EmailTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EmailTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun emailTemplate(name: String): EmailTemplate {
    val builder = EmailTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
