@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.GatewayApiEntityTagArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.ProvisioningState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * API details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateGatewayApi
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gatewayApiEntityTag = new AzureNative.ApiManagement.GatewayApiEntityTag("gatewayApiEntityTag", new()
 *     {
 *         ApiId = "echo-api",
 *         GatewayId = "gw1",
 *         ProvisioningState = AzureNative.ApiManagement.ProvisioningState.Created,
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewGatewayApiEntityTag(ctx, "gatewayApiEntityTag", &apimanagement.GatewayApiEntityTagArgs{
 * 			ApiId:             pulumi.String("echo-api"),
 * 			GatewayId:         pulumi.String("gw1"),
 * 			ProvisioningState: apimanagement.ProvisioningStateCreated,
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.GatewayApiEntityTag;
 * import com.pulumi.azurenative.apimanagement.GatewayApiEntityTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gatewayApiEntityTag = new GatewayApiEntityTag("gatewayApiEntityTag", GatewayApiEntityTagArgs.builder()
 *             .apiId("echo-api")
 *             .gatewayId("gw1")
 *             .provisioningState("created")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:GatewayApiEntityTag echo-api /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/gateways/{gatewayId}/apis/{apiId}
 * ```
 * @property apiId API identifier. Must be unique in the current API Management service instance.
 * @property gatewayId Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
 * @property provisioningState Provisioning state.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GatewayApiEntityTagArgs(
    public val apiId: Output<String>? = null,
    public val gatewayId: Output<String>? = null,
    public val provisioningState: Output<ProvisioningState>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.GatewayApiEntityTagArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.GatewayApiEntityTagArgs =
        com.pulumi.azurenative.apimanagement.GatewayApiEntityTagArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .gatewayId(gatewayId?.applyValue({ args0 -> args0 }))
            .provisioningState(provisioningState?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayApiEntityTagArgs].
 */
@PulumiTagMarker
public class GatewayApiEntityTagArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var gatewayId: Output<String>? = null

    private var provisioningState: Output<ProvisioningState>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value API identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("toojdrayugilsvsg")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
     */
    @JvmName("yippmgsugmxfcebc")
    public suspend fun gatewayId(`value`: Output<String>) {
        this.gatewayId = value
    }

    /**
     * @param value Provisioning state.
     */
    @JvmName("nbmufqsqtxuvytdg")
    public suspend fun provisioningState(`value`: Output<ProvisioningState>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kggwpnrxloqxkysa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("wsvxhqiintbmqvwg")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value API identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("ewycferjyqgivpas")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
     */
    @JvmName("klvrqxvfbywkmnmw")
    public suspend fun gatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayId = mapped
    }

    /**
     * @param value Provisioning state.
     */
    @JvmName("fcprlxixjapnujwg")
    public suspend fun provisioningState(`value`: ProvisioningState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("keiofpxkvhmqrbiv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("airmfturgmimxbib")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): GatewayApiEntityTagArgs = GatewayApiEntityTagArgs(
        apiId = apiId,
        gatewayId = gatewayId,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
