@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GatewayCertificateAuthority].
 */
@PulumiTagMarker
public class GatewayCertificateAuthorityResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayCertificateAuthorityArgs = GatewayCertificateAuthorityArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayCertificateAuthorityArgsBuilder.() -> Unit) {
        val builder = GatewayCertificateAuthorityArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GatewayCertificateAuthority {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.GatewayCertificateAuthority(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GatewayCertificateAuthority(builtJavaResource)
    }
}

/**
 * Gateway certificate authority details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateGatewayCertificateAuthority
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gatewayCertificateAuthority = new AzureNative.ApiManagement.GatewayCertificateAuthority("gatewayCertificateAuthority", new()
 *     {
 *         CertificateId = "cert1",
 *         GatewayId = "gw1",
 *         IsTrusted = false,
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewGatewayCertificateAuthority(ctx, "gatewayCertificateAuthority", &apimanagement.GatewayCertificateAuthorityArgs{
 * 			CertificateId:     pulumi.String("cert1"),
 * 			GatewayId:         pulumi.String("gw1"),
 * 			IsTrusted:         pulumi.Bool(false),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.GatewayCertificateAuthority;
 * import com.pulumi.azurenative.apimanagement.GatewayCertificateAuthorityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gatewayCertificateAuthority = new GatewayCertificateAuthority("gatewayCertificateAuthority", GatewayCertificateAuthorityArgs.builder()
 *             .certificateId("cert1")
 *             .gatewayId("gw1")
 *             .isTrusted(false)
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:GatewayCertificateAuthority cert1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/gateways/{gatewayId}/certificateAuthorities/{certificateId}
 * ```
 */
public class GatewayCertificateAuthority internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.GatewayCertificateAuthority,
) : KotlinCustomResource(javaResource, GatewayCertificateAuthorityMapper) {
    /**
     * Determines whether certificate authority is trusted.
     */
    public val isTrusted: Output<Boolean>?
        get() = javaResource.isTrusted().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GatewayCertificateAuthorityMapper : ResourceMapper<GatewayCertificateAuthority> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.GatewayCertificateAuthority::class == javaResource::class

    override fun map(javaResource: Resource): GatewayCertificateAuthority =
        GatewayCertificateAuthority(
            javaResource as
                com.pulumi.azurenative.apimanagement.GatewayCertificateAuthority,
        )
}

/**
 * @see [GatewayCertificateAuthority].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GatewayCertificateAuthority].
 */
public suspend fun gatewayCertificateAuthority(
    name: String,
    block: suspend GatewayCertificateAuthorityResourceBuilder.() -> Unit,
):
    GatewayCertificateAuthority {
    val builder = GatewayCertificateAuthorityResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GatewayCertificateAuthority].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gatewayCertificateAuthority(name: String): GatewayCertificateAuthority {
    val builder = GatewayCertificateAuthorityResourceBuilder()
    builder.name(name)
    return builder.build()
}
