@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.GroupArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.GroupType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @group = new AzureNative.ApiManagement.Group("group", new()
 *     {
 *         DisplayName = "temp group",
 *         GroupId = "tempgroup",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewGroup(ctx, "group", &apimanagement.GroupArgs{
 * 			DisplayName:       pulumi.String("temp group"),
 * 			GroupId:           pulumi.String("tempgroup"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Group;
 * import com.pulumi.azurenative.apimanagement.GroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var group = new Group("group", GroupArgs.builder()
 *             .displayName("temp group")
 *             .groupId("tempgroup")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateGroupExternal
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @group = new AzureNative.ApiManagement.Group("group", new()
 *     {
 *         Description = "new group to test",
 *         DisplayName = "NewGroup (samiraad.onmicrosoft.com)",
 *         ExternalId = "aad://samiraad.onmicrosoft.com/groups/83cf2753-5831-4675-bc0e-2f8dc067c58d",
 *         GroupId = "aadGroup",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Type = AzureNative.ApiManagement.GroupType.External,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewGroup(ctx, "group", &apimanagement.GroupArgs{
 * 			Description:       pulumi.String("new group to test"),
 * 			DisplayName:       pulumi.String("NewGroup (samiraad.onmicrosoft.com)"),
 * 			ExternalId:        pulumi.String("aad://samiraad.onmicrosoft.com/groups/83cf2753-5831-4675-bc0e-2f8dc067c58d"),
 * 			GroupId:           pulumi.String("aadGroup"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Type:              apimanagement.GroupTypeExternal,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Group;
 * import com.pulumi.azurenative.apimanagement.GroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var group = new Group("group", GroupArgs.builder()
 *             .description("new group to test")
 *             .displayName("NewGroup (samiraad.onmicrosoft.com)")
 *             .externalId("aad://samiraad.onmicrosoft.com/groups/83cf2753-5831-4675-bc0e-2f8dc067c58d")
 *             .groupId("aadGroup")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .type("external")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Group aadGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/groups/{groupId}
 * ```
 * @property description Group description.
 * @property displayName Group name.
 * @property externalId Identifier of the external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory `aad://<tenant>.onmicrosoft.com/groups/<group object id>`; otherwise the value is null.
 * @property groupId Group identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property type Group type.
 */
public data class GroupArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val externalId: Output<String>? = null,
    public val groupId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val type: Output<GroupType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.GroupArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.GroupArgs =
        com.pulumi.azurenative.apimanagement.GroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .externalId(externalId?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var externalId: Output<String>? = null

    private var groupId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var type: Output<GroupType>? = null

    /**
     * @param value Group description.
     */
    @JvmName("rshdhxxpixygmpkx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Group name.
     */
    @JvmName("ayrfthdkurlvxdsw")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Identifier of the external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory `aad://<tenant>.onmicrosoft.com/groups/<group object id>`; otherwise the value is null.
     */
    @JvmName("mkwphcowoaxcdsfa")
    public suspend fun externalId(`value`: Output<String>) {
        this.externalId = value
    }

    /**
     * @param value Group identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("vakhxufjvbvrnrfs")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("smnewtiylqgbbvmi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("rpeqiowstleasdmf")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Group type.
     */
    @JvmName("sggydikfnuvrjyko")
    public suspend fun type(`value`: Output<GroupType>) {
        this.type = value
    }

    /**
     * @param value Group description.
     */
    @JvmName("ggsuapgrgudwcspu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Group name.
     */
    @JvmName("dljrayctaifwcajq")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Identifier of the external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory `aad://<tenant>.onmicrosoft.com/groups/<group object id>`; otherwise the value is null.
     */
    @JvmName("lpefkyvfcwcqbsxx")
    public suspend fun externalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalId = mapped
    }

    /**
     * @param value Group identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("wkghdjsgjaybrxvu")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xacvpedxuaohtgyp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("qnvkdnqwavelxuwj")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Group type.
     */
    @JvmName("yjmcidqpoflytooy")
    public suspend fun type(`value`: GroupType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        description = description,
        displayName = displayName,
        externalId = externalId,
        groupId = groupId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        type = type,
    )
}
