@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.PolicyFragmentArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.PolicyFragmentContentFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Policy fragment contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreatePolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyFragment = new AzureNative.ApiManagement.PolicyFragment("policyFragment", new()
 *     {
 *         Description = "A policy fragment example",
 *         Format = "xml",
 *         Id = "policyFragment1",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = "<fragment><json-to-xml apply=\"always\" consider-accept-header=\"false\" /></fragment>",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewPolicyFragment(ctx, "policyFragment", &apimanagement.PolicyFragmentArgs{
 * 			Description:       pulumi.String("A policy fragment example"),
 * 			Format:            pulumi.String("xml"),
 * 			Id:                pulumi.String("policyFragment1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value:             pulumi.String("<fragment><json-to-xml apply=\"always\" consider-accept-header=\"false\" /></fragment>"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.PolicyFragment;
 * import com.pulumi.azurenative.apimanagement.PolicyFragmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyFragment = new PolicyFragment("policyFragment", PolicyFragmentArgs.builder()
 *             .description("A policy fragment example")
 *             .format("xml")
 *             .id("policyFragment1")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("<fragment><json-to-xml apply=\"always\" consider-accept-header=\"false\" /></fragment>")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:PolicyFragment policyFragment1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/policyFragments/{id}
 * ```
 * @property description Policy fragment description.
 * @property format Format of the policy fragment content.
 * @property id A resource identifier.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property value Contents of the policy fragment.
 */
public data class PolicyFragmentArgs(
    public val description: Output<String>? = null,
    public val format: Output<Either<String, PolicyFragmentContentFormat>>? = null,
    public val id: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.PolicyFragmentArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.PolicyFragmentArgs =
        com.pulumi.azurenative.apimanagement.PolicyFragmentArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .format(
                format?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyFragmentArgs].
 */
@PulumiTagMarker
public class PolicyFragmentArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var format: Output<Either<String, PolicyFragmentContentFormat>>? = null

    private var id: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Policy fragment description.
     */
    @JvmName("iiauattamxgjdatp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Format of the policy fragment content.
     */
    @JvmName("oxcrykjedmndttyp")
    public suspend fun format(`value`: Output<Either<String, PolicyFragmentContentFormat>>) {
        this.format = value
    }

    /**
     * @param value A resource identifier.
     */
    @JvmName("banwptmgmgcmbatx")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fjmsxiqoigcbefyk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("xaurvsncsogomjkf")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Contents of the policy fragment.
     */
    @JvmName("qahsatebnypmbqym")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Policy fragment description.
     */
    @JvmName("npkvvdwerkvrhugk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Format of the policy fragment content.
     */
    @JvmName("qmrotqnmkekvxqat")
    public suspend fun format(`value`: Either<String, PolicyFragmentContentFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Format of the policy fragment content.
     */
    @JvmName("ptqquwgxyneawjra")
    public fun format(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyFragmentContentFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Format of the policy fragment content.
     */
    @JvmName("mlsqfaneasrxuyer")
    public fun format(`value`: PolicyFragmentContentFormat) {
        val toBeMapped = Either.ofRight<String, PolicyFragmentContentFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value A resource identifier.
     */
    @JvmName("xyyyodloijnffpge")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sqpsmpwfwsnxnmot")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("bsgwlspbtiulpnke")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Contents of the policy fragment.
     */
    @JvmName("iwutbmjbhdyiaqfi")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): PolicyFragmentArgs = PolicyFragmentArgs(
        description = description,
        format = format,
        id = id,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        `value` = `value`,
    )
}
