@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.PolicyRestrictionArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.PolicyRestrictionRequireBase
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Policy restriction contract details.
 * Azure REST API version: 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreatePolicyRestriction
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyRestriction = new AzureNative.ApiManagement.PolicyRestriction("policyRestriction", new()
 *     {
 *         PolicyRestrictionId = "policyRestriction1",
 *         RequireBase = "true",
 *         ResourceGroupName = "rg1",
 *         Scope = "Sample Path to the policy document.",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewPolicyRestriction(ctx, "policyRestriction", &apimanagement.PolicyRestrictionArgs{
 * 			PolicyRestrictionId: pulumi.String("policyRestriction1"),
 * 			RequireBase:         pulumi.String("true"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			Scope:               pulumi.String("Sample Path to the policy document."),
 * 			ServiceName:         pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.PolicyRestriction;
 * import com.pulumi.azurenative.apimanagement.PolicyRestrictionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyRestriction = new PolicyRestriction("policyRestriction", PolicyRestrictionArgs.builder()
 *             .policyRestrictionId("policyRestriction1")
 *             .requireBase("true")
 *             .resourceGroupName("rg1")
 *             .scope("Sample Path to the policy document.")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:PolicyRestriction policyRestrictions1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/policyRestrictions/{policyRestrictionId}
 * ```
 * @property policyRestrictionId Policy restrictions after an entity level
 * @property requireBase Indicates if base policy should be enforced for the policy document.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scope Path to the policy document.
 * @property serviceName The name of the API Management service.
 */
public data class PolicyRestrictionArgs(
    public val policyRestrictionId: Output<String>? = null,
    public val requireBase: Output<Either<String, PolicyRestrictionRequireBase>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.PolicyRestrictionArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.PolicyRestrictionArgs =
        com.pulumi.azurenative.apimanagement.PolicyRestrictionArgs.builder()
            .policyRestrictionId(policyRestrictionId?.applyValue({ args0 -> args0 }))
            .requireBase(
                requireBase?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyRestrictionArgs].
 */
@PulumiTagMarker
public class PolicyRestrictionArgsBuilder internal constructor() {
    private var policyRestrictionId: Output<String>? = null

    private var requireBase: Output<Either<String, PolicyRestrictionRequireBase>>? = null

    private var resourceGroupName: Output<String>? = null

    private var scope: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Policy restrictions after an entity level
     */
    @JvmName("lxgvbuyiosobpgkc")
    public suspend fun policyRestrictionId(`value`: Output<String>) {
        this.policyRestrictionId = value
    }

    /**
     * @param value Indicates if base policy should be enforced for the policy document.
     */
    @JvmName("prxxqjdxqggbgqbt")
    public suspend fun requireBase(`value`: Output<Either<String, PolicyRestrictionRequireBase>>) {
        this.requireBase = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cdkbniywxbunqnet")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Path to the policy document.
     */
    @JvmName("dpngkbfyvabaitqc")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("ufstlhnjoafqsfko")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Policy restrictions after an entity level
     */
    @JvmName("hxegntqthcithjbm")
    public suspend fun policyRestrictionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyRestrictionId = mapped
    }

    /**
     * @param value Indicates if base policy should be enforced for the policy document.
     */
    @JvmName("mpilgppmieicntfh")
    public suspend fun requireBase(`value`: Either<String, PolicyRestrictionRequireBase>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireBase = mapped
    }

    /**
     * @param value Indicates if base policy should be enforced for the policy document.
     */
    @JvmName("eolkedueuvnljknd")
    public fun requireBase(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyRestrictionRequireBase>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requireBase = mapped
    }

    /**
     * @param value Indicates if base policy should be enforced for the policy document.
     */
    @JvmName("ahmfawlbouknvbil")
    public fun requireBase(`value`: PolicyRestrictionRequireBase) {
        val toBeMapped = Either.ofRight<String, PolicyRestrictionRequireBase>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requireBase = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hqhvufabkomafcwf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Path to the policy document.
     */
    @JvmName("qcbmokftubcndslm")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("osjdwdnshfoqknmd")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): PolicyRestrictionArgs = PolicyRestrictionArgs(
        policyRestrictionId = policyRestrictionId,
        requireBase = requireBase,
        resourceGroupName = resourceGroupName,
        scope = scope,
        serviceName = serviceName,
    )
}
