@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.kotlin.outputs.GroupContractPropertiesResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.UserIdentityContractResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.apimanagement.kotlin.outputs.GroupContractPropertiesResponse.Companion.toKotlin as groupContractPropertiesResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.UserIdentityContractResponse.Companion.toKotlin as userIdentityContractResponseToKotlin

/**
 * Builder for [User].
 */
@PulumiTagMarker
public class UserResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserArgs = UserArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserArgsBuilder.() -> Unit) {
        val builder = UserArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): User {
        val builtJavaResource = com.pulumi.azurenative.apimanagement.User(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return User(builtJavaResource)
    }
}

/**
 * User details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2017-03-01, 2018-01-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateUser
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var user = new AzureNative.ApiManagement.User("user", new()
 *     {
 *         Confirmation = "signup",
 *         Email = "foobar@outlook.com",
 *         FirstName = "foo",
 *         LastName = "bar",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         UserId = "5931a75ae4bbd512288c680b",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewUser(ctx, "user", &apimanagement.UserArgs{
 * 			Confirmation:      pulumi.String("signup"),
 * 			Email:             pulumi.String("foobar@outlook.com"),
 * 			FirstName:         pulumi.String("foo"),
 * 			LastName:          pulumi.String("bar"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			UserId:            pulumi.String("5931a75ae4bbd512288c680b"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.User;
 * import com.pulumi.azurenative.apimanagement.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user = new User("user", UserArgs.builder()
 *             .confirmation("signup")
 *             .email("foobar@outlook.com")
 *             .firstName("foo")
 *             .lastName("bar")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .userId("5931a75ae4bbd512288c680b")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:User 5931a75ae4bbd512288c680b /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/users/{userId}
 * ```
 */
public class User internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.User,
) : KotlinCustomResource(javaResource, UserMapper) {
    /**
     * Email address.
     */
    public val email: Output<String>?
        get() = javaResource.email().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * First name.
     */
    public val firstName: Output<String>?
        get() = javaResource.firstName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Collection of groups user is part of.
     */
    public val groups: Output<List<GroupContractPropertiesResponse>>
        get() = javaResource.groups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    groupContractPropertiesResponseToKotlin(args0)
                })
            })
        })

    /**
     * Collection of user identities.
     */
    public val identities: Output<List<UserIdentityContractResponse>>?
        get() = javaResource.identities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> userIdentityContractResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Last name.
     */
    public val lastName: Output<String>?
        get() = javaResource.lastName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Optional note about a user set by the administrator.
     */
    public val note: Output<String>?
        get() = javaResource.note().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Date of user registration. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     */
    public val registrationDate: Output<String>?
        get() = javaResource.registrationDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object UserMapper : ResourceMapper<User> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.User::class == javaResource::class

    override fun map(javaResource: Resource): User = User(
        javaResource as
            com.pulumi.azurenative.apimanagement.User,
    )
}

/**
 * @see [User].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [User].
 */
public suspend fun user(name: String, block: suspend UserResourceBuilder.() -> Unit): User {
    val builder = UserResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [User].
 * @param name The _unique_ name of the resulting resource.
 */
public fun user(name: String): User {
    val builder = UserResourceBuilder()
    builder.name(name)
    return builder.build()
}
