@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.WorkspaceApiPolicyArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.PolicyContentFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Policy Contract details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspaceApiPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceApiPolicy = new AzureNative.ApiManagement.WorkspaceApiPolicy("workspaceApiPolicy", new()
 *     {
 *         ApiId = "5600b57e7e8880006a040001",
 *         Format = "xml",
 *         PolicyId = "policy",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = "<policies> <inbound /> <backend>    <forward-request />  </backend>  <outbound /></policies>",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceApiPolicy(ctx, "workspaceApiPolicy", &apimanagement.WorkspaceApiPolicyArgs{
 * 			ApiId:             pulumi.String("5600b57e7e8880006a040001"),
 * 			Format:            pulumi.String("xml"),
 * 			PolicyId:          pulumi.String("policy"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value:             pulumi.String("<policies> <inbound /> <backend>    <forward-request />  </backend>  <outbound /></policies>"),
 * 			WorkspaceId:       pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceApiPolicy;
 * import com.pulumi.azurenative.apimanagement.WorkspaceApiPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceApiPolicy = new WorkspaceApiPolicy("workspaceApiPolicy", WorkspaceApiPolicyArgs.builder()
 *             .apiId("5600b57e7e8880006a040001")
 *             .format("xml")
 *             .policyId("policy")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("<policies> <inbound /> <backend>    <forward-request />  </backend>  <outbound /></policies>")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspaceApiPolicy policy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/apis/{apiId}/policies/{policyId}
 * ```
 * @property apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
 * @property format Format of the policyContent.
 * @property policyId The identifier of the Policy.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property value Contents of the Policy as defined by the format.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class WorkspaceApiPolicyArgs(
    public val apiId: Output<String>? = null,
    public val format: Output<Either<String, PolicyContentFormat>>? = null,
    public val policyId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val `value`: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.WorkspaceApiPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.WorkspaceApiPolicyArgs =
        com.pulumi.azurenative.apimanagement.WorkspaceApiPolicyArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .format(
                format?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceApiPolicyArgs].
 */
@PulumiTagMarker
public class WorkspaceApiPolicyArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var format: Output<Either<String, PolicyContentFormat>>? = null

    private var policyId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var `value`: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("frdoxwxrlyvkhhqg")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Format of the policyContent.
     */
    @JvmName("hnhoeecoepocffkr")
    public suspend fun format(`value`: Output<Either<String, PolicyContentFormat>>) {
        this.format = value
    }

    /**
     * @param value The identifier of the Policy.
     */
    @JvmName("yexnuvksnwkfwuln")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dcafhvwbbkmrvxli")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("njslutccodybeuth")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Contents of the Policy as defined by the format.
     */
    @JvmName("mkmjheqyhjdofatb")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("ojuahpbjvdysvtrm")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("mqbujfxovgqvmntk")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Format of the policyContent.
     */
    @JvmName("fxwonaoccqkvhuhp")
    public suspend fun format(`value`: Either<String, PolicyContentFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Format of the policyContent.
     */
    @JvmName("bhekewrluqrgfhbs")
    public fun format(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyContentFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Format of the policyContent.
     */
    @JvmName("umgguytwuvxgopfw")
    public fun format(`value`: PolicyContentFormat) {
        val toBeMapped = Either.ofRight<String, PolicyContentFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The identifier of the Policy.
     */
    @JvmName("pjoospqnejnylfnr")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nnwkbsvnkgllbfee")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("qdwatgkexinmdlkl")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Contents of the Policy as defined by the format.
     */
    @JvmName("rfatxadyjqiplglf")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("lohthuedpvpoqivi")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): WorkspaceApiPolicyArgs = WorkspaceApiPolicyArgs(
        apiId = apiId,
        format = format,
        policyId = policyId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        `value` = `value`,
        workspaceId = workspaceId,
    )
}
