@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.WorkspaceApiReleaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ApiRelease details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspaceApiRelease
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceApiRelease = new AzureNative.ApiManagement.WorkspaceApiRelease("workspaceApiRelease", new()
 *     {
 *         ApiId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/workspaces/wks1/apis/a1",
 *         Notes = "yahooagain",
 *         ReleaseId = "testrev",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceApiRelease(ctx, "workspaceApiRelease", &apimanagement.WorkspaceApiReleaseArgs{
 * 			ApiId:             pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/workspaces/wks1/apis/a1"),
 * 			Notes:             pulumi.String("yahooagain"),
 * 			ReleaseId:         pulumi.String("testrev"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			WorkspaceId:       pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceApiRelease;
 * import com.pulumi.azurenative.apimanagement.WorkspaceApiReleaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceApiRelease = new WorkspaceApiRelease("workspaceApiRelease", WorkspaceApiReleaseArgs.builder()
 *             .apiId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/workspaces/wks1/apis/a1")
 *             .notes("yahooagain")
 *             .releaseId("testrev")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspaceApiRelease testrev /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/apis/{apiId}/releases/{releaseId}
 * ```
 * @property apiId Identifier of the API the release belongs to.
 * @property notes Release Notes
 * @property releaseId Release identifier within an API. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class WorkspaceApiReleaseArgs(
    public val apiId: Output<String>? = null,
    public val notes: Output<String>? = null,
    public val releaseId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.WorkspaceApiReleaseArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.WorkspaceApiReleaseArgs =
        com.pulumi.azurenative.apimanagement.WorkspaceApiReleaseArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .notes(notes?.applyValue({ args0 -> args0 }))
            .releaseId(releaseId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceApiReleaseArgs].
 */
@PulumiTagMarker
public class WorkspaceApiReleaseArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var notes: Output<String>? = null

    private var releaseId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value Identifier of the API the release belongs to.
     */
    @JvmName("pwejymhinsdkjfxy")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Release Notes
     */
    @JvmName("pqfguvpofpslggql")
    public suspend fun notes(`value`: Output<String>) {
        this.notes = value
    }

    /**
     * @param value Release identifier within an API. Must be unique in the current API Management service instance.
     */
    @JvmName("rihjfhwvlofbubps")
    public suspend fun releaseId(`value`: Output<String>) {
        this.releaseId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("csqovwurdbgkynbh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("xoukwsdxgxainhhh")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("dcexhtfhsxgsbeul")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value Identifier of the API the release belongs to.
     */
    @JvmName("olpxsnwkqxurvdsp")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Release Notes
     */
    @JvmName("endspfmkcsaseoes")
    public suspend fun notes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notes = mapped
    }

    /**
     * @param value Release identifier within an API. Must be unique in the current API Management service instance.
     */
    @JvmName("jqshpcvigdakilyj")
    public suspend fun releaseId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pjctkaiqttfndrdd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("rwrutlasmerpuxif")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("gvjcsqpsuvpjwkwu")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): WorkspaceApiReleaseArgs = WorkspaceApiReleaseArgs(
        apiId = apiId,
        notes = notes,
        releaseId = releaseId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        workspaceId = workspaceId,
    )
}
