@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.WorkspaceGroupUserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * User details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspaceGroupUser
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceGroupUser = new AzureNative.ApiManagement.WorkspaceGroupUser("workspaceGroupUser", new()
 *     {
 *         GroupId = "tempgroup",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         UserId = "59307d350af58404d8a26300",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceGroupUser(ctx, "workspaceGroupUser", &apimanagement.WorkspaceGroupUserArgs{
 * 			GroupId:           pulumi.String("tempgroup"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			UserId:            pulumi.String("59307d350af58404d8a26300"),
 * 			WorkspaceId:       pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceGroupUser;
 * import com.pulumi.azurenative.apimanagement.WorkspaceGroupUserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceGroupUser = new WorkspaceGroupUser("workspaceGroupUser", WorkspaceGroupUserArgs.builder()
 *             .groupId("tempgroup")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .userId("59307d350af58404d8a26300")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspaceGroupUser 59307d350af58404d8a26300 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/groups/{groupId}/users/{userId}
 * ```
 * @property groupId Group identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property userId User identifier. Must be unique in the current API Management service instance.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class WorkspaceGroupUserArgs(
    public val groupId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val userId: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.WorkspaceGroupUserArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.WorkspaceGroupUserArgs =
        com.pulumi.azurenative.apimanagement.WorkspaceGroupUserArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .userId(userId?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceGroupUserArgs].
 */
@PulumiTagMarker
public class WorkspaceGroupUserArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var userId: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value Group identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("sybcptixoguddhji")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ppyxntfxarpjnekq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("ixjctndmuevkvnyp")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value User identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("mjavscmutjpqpgrm")
    public suspend fun userId(`value`: Output<String>) {
        this.userId = value
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("ailbiurhlybhaggu")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value Group identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("rrsqvsopwwyqulxl")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qkhbtieppkytcvfx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("mmdbrpgdopufqwsl")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value User identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("tiupulfgrepdbufs")
    public suspend fun userId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("txnfycjwoumjugca")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): WorkspaceGroupUserArgs = WorkspaceGroupUserArgs(
        groupId = groupId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        userId = userId,
        workspaceId = workspaceId,
    )
}
