@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientEmailArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Recipient Email details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspaceNotificationRecipientEmail
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceNotificationRecipientEmail = new AzureNative.ApiManagement.WorkspaceNotificationRecipientEmail("workspaceNotificationRecipientEmail", new()
 *     {
 *         Email = "foobar@live.com",
 *         NotificationName = "RequestPublisherNotificationMessage",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceNotificationRecipientEmail(ctx, "workspaceNotificationRecipientEmail", &apimanagement.WorkspaceNotificationRecipientEmailArgs{
 * 			Email:             pulumi.String("foobar@live.com"),
 * 			NotificationName:  pulumi.String("RequestPublisherNotificationMessage"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			WorkspaceId:       pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientEmail;
 * import com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientEmailArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceNotificationRecipientEmail = new WorkspaceNotificationRecipientEmail("workspaceNotificationRecipientEmail", WorkspaceNotificationRecipientEmailArgs.builder()
 *             .email("foobar@live.com")
 *             .notificationName("RequestPublisherNotificationMessage")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspaceNotificationRecipientEmail foobar@live.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/notifications/{notificationName}/recipientEmails/{email}
 * ```
 * @property email Email identifier.
 * @property notificationName Notification Name Identifier.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class WorkspaceNotificationRecipientEmailArgs(
    public val email: Output<String>? = null,
    public val notificationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientEmailArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientEmailArgs =
        com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientEmailArgs.builder()
            .email(email?.applyValue({ args0 -> args0 }))
            .notificationName(notificationName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceNotificationRecipientEmailArgs].
 */
@PulumiTagMarker
public class WorkspaceNotificationRecipientEmailArgsBuilder internal constructor() {
    private var email: Output<String>? = null

    private var notificationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value Email identifier.
     */
    @JvmName("ghremsvjysohpuos")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value Notification Name Identifier.
     */
    @JvmName("yndlismxygjjblwu")
    public suspend fun notificationName(`value`: Output<String>) {
        this.notificationName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mnlxlebrdlfstydi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("vedppiclheecysjp")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("qoewgeanjceexxfl")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value Email identifier.
     */
    @JvmName("xfvxoaydmicvlyfh")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value Notification Name Identifier.
     */
    @JvmName("vepqcilewmxlbigx")
    public suspend fun notificationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pjstitkmdwpkfhob")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("tttmpofoectrchdx")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("oevvgfkwjconbpnt")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): WorkspaceNotificationRecipientEmailArgs =
        WorkspaceNotificationRecipientEmailArgs(
            email = email,
            notificationName = notificationName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            workspaceId = workspaceId,
        )
}
