@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.WorkspacePolicyFragmentArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.PolicyFragmentContentFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Policy fragment contract details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspacePolicyFragment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspacePolicyFragment = new AzureNative.ApiManagement.WorkspacePolicyFragment("workspacePolicyFragment", new()
 *     {
 *         Description = "A policy fragment example",
 *         Format = "xml",
 *         Id = "policyFragment1",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = "<fragment><json-to-xml apply=\"always\" consider-accept-header=\"false\" /></fragment>",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspacePolicyFragment(ctx, "workspacePolicyFragment", &apimanagement.WorkspacePolicyFragmentArgs{
 * 			Description:       pulumi.String("A policy fragment example"),
 * 			Format:            pulumi.String("xml"),
 * 			Id:                pulumi.String("policyFragment1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value:             pulumi.String("<fragment><json-to-xml apply=\"always\" consider-accept-header=\"false\" /></fragment>"),
 * 			WorkspaceId:       pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspacePolicyFragment;
 * import com.pulumi.azurenative.apimanagement.WorkspacePolicyFragmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspacePolicyFragment = new WorkspacePolicyFragment("workspacePolicyFragment", WorkspacePolicyFragmentArgs.builder()
 *             .description("A policy fragment example")
 *             .format("xml")
 *             .id("policyFragment1")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("<fragment><json-to-xml apply=\"always\" consider-accept-header=\"false\" /></fragment>")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspacePolicyFragment policyFragment1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/policyFragments/{id}
 * ```
 * @property description Policy fragment description.
 * @property format Format of the policy fragment content.
 * @property id A resource identifier.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property value Contents of the policy fragment.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class WorkspacePolicyFragmentArgs(
    public val description: Output<String>? = null,
    public val format: Output<Either<String, PolicyFragmentContentFormat>>? = null,
    public val id: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val `value`: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.WorkspacePolicyFragmentArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.WorkspacePolicyFragmentArgs =
        com.pulumi.azurenative.apimanagement.WorkspacePolicyFragmentArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .format(
                format?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspacePolicyFragmentArgs].
 */
@PulumiTagMarker
public class WorkspacePolicyFragmentArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var format: Output<Either<String, PolicyFragmentContentFormat>>? = null

    private var id: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var `value`: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value Policy fragment description.
     */
    @JvmName("cllqvxnbuoscdqfx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Format of the policy fragment content.
     */
    @JvmName("qthfqoyflbifyhgf")
    public suspend fun format(`value`: Output<Either<String, PolicyFragmentContentFormat>>) {
        this.format = value
    }

    /**
     * @param value A resource identifier.
     */
    @JvmName("weavkexqtwitblay")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pfsgqyomidyoohuv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("yckjxagoheqevhix")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Contents of the policy fragment.
     */
    @JvmName("udrxmaybvasrjdew")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("olomiarsellqnddk")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value Policy fragment description.
     */
    @JvmName("dlqvbchwuvmjttjt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Format of the policy fragment content.
     */
    @JvmName("brhunhlpnpkodcmj")
    public suspend fun format(`value`: Either<String, PolicyFragmentContentFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Format of the policy fragment content.
     */
    @JvmName("lcyhndnrfhxtsoro")
    public fun format(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyFragmentContentFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Format of the policy fragment content.
     */
    @JvmName("cyvcrcjlgdurotig")
    public fun format(`value`: PolicyFragmentContentFormat) {
        val toBeMapped = Either.ofRight<String, PolicyFragmentContentFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value A resource identifier.
     */
    @JvmName("ubtjdgxoxmkidffy")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nrdexmornxmtwlkk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("vcqdmhlphewguxen")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Contents of the policy fragment.
     */
    @JvmName("nmvhxrbtrbailcjy")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("bnxsjfhhffkapfxw")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): WorkspacePolicyFragmentArgs = WorkspacePolicyFragmentArgs(
        description = description,
        format = format,
        id = id,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        `value` = `value`,
        workspaceId = workspaceId,
    )
}
