@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkspaceProductGroupLink].
 */
@PulumiTagMarker
public class WorkspaceProductGroupLinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceProductGroupLinkArgs = WorkspaceProductGroupLinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceProductGroupLinkArgsBuilder.() -> Unit) {
        val builder = WorkspaceProductGroupLinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WorkspaceProductGroupLink {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.WorkspaceProductGroupLink(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspaceProductGroupLink(builtJavaResource)
    }
}

/**
 * Product-group link details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspaceProductGroupLink
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceProductGroupLink = new AzureNative.ApiManagement.WorkspaceProductGroupLink("workspaceProductGroupLink", new()
 *     {
 *         GroupId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/workspaces/wks1/groups/group1",
 *         GroupLinkId = "link1",
 *         ProductId = "testproduct",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceProductGroupLink(ctx, "workspaceProductGroupLink", &apimanagement.WorkspaceProductGroupLinkArgs{
 * 			GroupId:           pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/workspaces/wks1/groups/group1"),
 * 			GroupLinkId:       pulumi.String("link1"),
 * 			ProductId:         pulumi.String("testproduct"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			WorkspaceId:       pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceProductGroupLink;
 * import com.pulumi.azurenative.apimanagement.WorkspaceProductGroupLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceProductGroupLink = new WorkspaceProductGroupLink("workspaceProductGroupLink", WorkspaceProductGroupLinkArgs.builder()
 *             .groupId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/workspaces/wks1/groups/group1")
 *             .groupLinkId("link1")
 *             .productId("testproduct")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspaceProductGroupLink link1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/products/{productId}/groupLinks/{groupLinkId}
 * ```
 */
public class WorkspaceProductGroupLink internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.WorkspaceProductGroupLink,
) : KotlinCustomResource(javaResource, WorkspaceProductGroupLinkMapper) {
    /**
     * Full resource Id of a group.
     */
    public val groupId: Output<String>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkspaceProductGroupLinkMapper : ResourceMapper<WorkspaceProductGroupLink> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.WorkspaceProductGroupLink::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceProductGroupLink =
        WorkspaceProductGroupLink(
            javaResource as
                com.pulumi.azurenative.apimanagement.WorkspaceProductGroupLink,
        )
}

/**
 * @see [WorkspaceProductGroupLink].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceProductGroupLink].
 */
public suspend fun workspaceProductGroupLink(
    name: String,
    block: suspend WorkspaceProductGroupLinkResourceBuilder.() -> Unit,
): WorkspaceProductGroupLink {
    val builder = WorkspaceProductGroupLinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceProductGroupLink].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceProductGroupLink(name: String): WorkspaceProductGroupLink {
    val builder = WorkspaceProductGroupLinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
