@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

public enum class GrantType(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.GrantType,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.GrantType> {
    /**
     * Authorization Code Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.1.
     */
    AuthorizationCode(com.pulumi.azurenative.apimanagement.enums.GrantType.AuthorizationCode),

    /**
     * Implicit Code Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.2.
     */
    Implicit(com.pulumi.azurenative.apimanagement.enums.GrantType.Implicit),

    /**
     * Resource Owner Password Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.3.
     */
    ResourceOwnerPassword(com.pulumi.azurenative.apimanagement.enums.GrantType.ResourceOwnerPassword),

    /**
     * Client Credentials Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.4.
     */
    ClientCredentials(com.pulumi.azurenative.apimanagement.enums.GrantType.ClientCredentials),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.GrantType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.GrantType): GrantType =
            GrantType.values().first { it.javaValue == javaType }
    }
}
