@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Property can be used to enable NAT Gateway for this API Management service.
 */
public enum class NatGatewayState(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.NatGatewayState,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.NatGatewayState> {
    /**
     * Nat Gateway is enabled for the service.
     */
    Enabled(com.pulumi.azurenative.apimanagement.enums.NatGatewayState.Enabled),

    /**
     * Nat Gateway is disabled for the service.
     */
    Disabled(com.pulumi.azurenative.apimanagement.enums.NatGatewayState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.NatGatewayState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.NatGatewayState):
            NatGatewayState = NatGatewayState.values().first { it.javaValue == javaType }
    }
}
