@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The format of the Operation Name for Application Insights telemetries. Default is Name.
 */
public enum class OperationNameFormat(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.OperationNameFormat,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.OperationNameFormat> {
    /**
     * API_NAME;rev=API_REVISION - OPERATION_NAME
     */
    Name(com.pulumi.azurenative.apimanagement.enums.OperationNameFormat.Name),

    /**
     * HTTP_VERB URL
     */
    Url(com.pulumi.azurenative.apimanagement.enums.OperationNameFormat.Url),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.OperationNameFormat = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.OperationNameFormat):
            OperationNameFormat = OperationNameFormat.values().first { it.javaValue == javaType }
    }
}
