@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Format of the policy fragment content.
 */
public enum class PolicyFragmentContentFormat(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.PolicyFragmentContentFormat,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.PolicyFragmentContentFormat> {
    /**
     * The contents are inline and Content type is an XML document.
     */
    Xml(com.pulumi.azurenative.apimanagement.enums.PolicyFragmentContentFormat.Xml),

    /**
     * The contents are inline and Content type is a non XML encoded policy document.
     */
    Rawxml(com.pulumi.azurenative.apimanagement.enums.PolicyFragmentContentFormat.Rawxml),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.PolicyFragmentContentFormat =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.PolicyFragmentContentFormat):
            PolicyFragmentContentFormat =
            PolicyFragmentContentFormat.values().first { it.javaValue == javaType }
    }
}
