@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of API to create.
 *  * `http` creates a REST API
 *  * `soap` creates a SOAP pass-through API
 *  * `websocket` creates websocket API
 *  * `graphql` creates GraphQL API.
 */
public enum class SoapApiType(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.SoapApiType,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.SoapApiType> {
    /**
     * Imports a SOAP API having a RESTful front end.
     */
    SoapToRest(com.pulumi.azurenative.apimanagement.enums.SoapApiType.SoapToRest),

    /**
     * Imports the SOAP API having a SOAP front end.
     */
    SoapPassThrough(com.pulumi.azurenative.apimanagement.enums.SoapApiType.SoapPassThrough),

    /**
     * Imports the API having a Websocket front end.
     */
    WebSocket(com.pulumi.azurenative.apimanagement.enums.SoapApiType.WebSocket),

    /**
     * Imports the API having a GraphQL front end.
     */
    GraphQL(com.pulumi.azurenative.apimanagement.enums.SoapApiType.GraphQL),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.SoapApiType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.SoapApiType):
            SoapApiType = SoapApiType.values().first { it.javaValue == javaType }
    }
}
