@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Strategy of translating required query parameters to template ones. By default has value 'template'. Possible values: 'template', 'query'
 */
public enum class TranslateRequiredQueryParametersConduct(
    public val javaValue:
    com.pulumi.azurenative.apimanagement.enums.TranslateRequiredQueryParametersConduct,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.TranslateRequiredQueryParametersConduct> {
    /**
     * Translates required query parameters to template ones. Is a default value
     */
    Template(com.pulumi.azurenative.apimanagement.enums.TranslateRequiredQueryParametersConduct.Template),

    /**
     * Leaves required query parameters as they are (no translation done).
     */
    Query(com.pulumi.azurenative.apimanagement.enums.TranslateRequiredQueryParametersConduct.Query),
    ;

    override fun toJava():
        com.pulumi.azurenative.apimanagement.enums.TranslateRequiredQueryParametersConduct = javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.TranslateRequiredQueryParametersConduct):
            TranslateRequiredQueryParametersConduct =
            TranslateRequiredQueryParametersConduct.values().first { it.javaValue == javaType }
    }
}
