@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The verbosity level applied to traces emitted by trace policies.
 */
public enum class Verbosity(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.Verbosity,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.Verbosity> {
    /**
     * All the traces emitted by trace policies will be sent to the logger attached to this diagnostic instance.
     */
    Verbose(com.pulumi.azurenative.apimanagement.enums.Verbosity.Verbose),

    /**
     * Traces with 'severity' set to 'information' and 'error' will be sent to the logger attached to this diagnostic instance.
     */
    Information(com.pulumi.azurenative.apimanagement.enums.Verbosity.Information),

    /**
     * Only traces with 'severity' set to 'error' will be sent to the logger attached to this diagnostic instance.
     */
    Error(com.pulumi.azurenative.apimanagement.enums.Verbosity.Error),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.Verbosity = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.Verbosity): Verbosity =
            Verbosity.values().first { it.javaValue == javaType }
    }
}
