@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.ApiContactInformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * API contact information
 * @property email The email address of the contact person/organization. MUST be in the format of an email address
 * @property name The identifying name of the contact person/organization
 * @property url The URL pointing to the contact information. MUST be in the format of a URL
 */
public data class ApiContactInformationArgs(
    public val email: Output<String>? = null,
    public val name: Output<String>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.ApiContactInformationArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.ApiContactInformationArgs =
        com.pulumi.azurenative.apimanagement.inputs.ApiContactInformationArgs.builder()
            .email(email?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiContactInformationArgs].
 */
@PulumiTagMarker
public class ApiContactInformationArgsBuilder internal constructor() {
    private var email: Output<String>? = null

    private var name: Output<String>? = null

    private var url: Output<String>? = null

    /**
     * @param value The email address of the contact person/organization. MUST be in the format of an email address
     */
    @JvmName("gxpyrhnhmhqqaivp")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value The identifying name of the contact person/organization
     */
    @JvmName("cxscprahmltnhjji")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The URL pointing to the contact information. MUST be in the format of a URL
     */
    @JvmName("fsjhgmqiwxdicghr")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The email address of the contact person/organization. MUST be in the format of an email address
     */
    @JvmName("bgvxyhtimtkkhoqt")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value The identifying name of the contact person/organization
     */
    @JvmName("tmehgrkbkeflihtv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The URL pointing to the contact information. MUST be in the format of a URL
     */
    @JvmName("kfqinhrgxncyhruc")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): ApiContactInformationArgs = ApiContactInformationArgs(
        email = email,
        name = name,
        url = url,
    )
}
