@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceSkuPropertiesArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.SkuType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * API Management service resource SKU properties.
 * @property capacity Capacity of the SKU (number of deployed units of the SKU). For Consumption SKU capacity must be specified as 0.
 * @property name Name of the Sku.
 */
public data class ApiManagementServiceSkuPropertiesArgs(
    public val capacity: Output<Int>,
    public val name: Output<Either<String, SkuType>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceSkuPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceSkuPropertiesArgs =
        com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceSkuPropertiesArgs.builder()
            .capacity(capacity.applyValue({ args0 -> args0 }))
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApiManagementServiceSkuPropertiesArgs].
 */
@PulumiTagMarker
public class ApiManagementServiceSkuPropertiesArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<Either<String, SkuType>>? = null

    /**
     * @param value Capacity of the SKU (number of deployed units of the SKU). For Consumption SKU capacity must be specified as 0.
     */
    @JvmName("irtyevbydpsnxspr")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Name of the Sku.
     */
    @JvmName("bswecqwbwfbocmne")
    public suspend fun name(`value`: Output<Either<String, SkuType>>) {
        this.name = value
    }

    /**
     * @param value Capacity of the SKU (number of deployed units of the SKU). For Consumption SKU capacity must be specified as 0.
     */
    @JvmName("kcjobrmqnkmwccnu")
    public suspend fun capacity(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Name of the Sku.
     */
    @JvmName("nvotuwlinvaflvep")
    public suspend fun name(`value`: Either<String, SkuType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the Sku.
     */
    @JvmName("uvkpgnliutrasnbg")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the Sku.
     */
    @JvmName("mtnlsniksjsqkjwk")
    public fun name(`value`: SkuType) {
        val toBeMapped = Either.ofRight<String, SkuType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ApiManagementServiceSkuPropertiesArgs =
        ApiManagementServiceSkuPropertiesArgs(
            capacity = capacity ?: throw PulumiNullFieldException("capacity"),
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
