@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.ApiVersionSetContractDetailsArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.VersioningScheme
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An API Version Set contains the common configuration for a set of API Versions relating
 * @property description Description of API Version Set.
 * @property id Identifier for existing API Version Set. Omit this value to create a new Version Set.
 * @property name The display Name of the API Version Set.
 * @property versionHeaderName Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
 * @property versionQueryName Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
 * @property versioningScheme An value that determines where the API Version identifier will be located in a HTTP request.
 */
public data class ApiVersionSetContractDetailsArgs(
    public val description: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val versionHeaderName: Output<String>? = null,
    public val versionQueryName: Output<String>? = null,
    public val versioningScheme: Output<Either<String, VersioningScheme>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.ApiVersionSetContractDetailsArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.ApiVersionSetContractDetailsArgs =
        com.pulumi.azurenative.apimanagement.inputs.ApiVersionSetContractDetailsArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .versionHeaderName(versionHeaderName?.applyValue({ args0 -> args0 }))
            .versionQueryName(versionQueryName?.applyValue({ args0 -> args0 }))
            .versioningScheme(
                versioningScheme?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [ApiVersionSetContractDetailsArgs].
 */
@PulumiTagMarker
public class ApiVersionSetContractDetailsArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var versionHeaderName: Output<String>? = null

    private var versionQueryName: Output<String>? = null

    private var versioningScheme: Output<Either<String, VersioningScheme>>? = null

    /**
     * @param value Description of API Version Set.
     */
    @JvmName("bhyxlaaendhwwiaw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Identifier for existing API Version Set. Omit this value to create a new Version Set.
     */
    @JvmName("neltcwnmoxviplky")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The display Name of the API Version Set.
     */
    @JvmName("udhtnisvoikoqbeu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
     */
    @JvmName("jxjiqkpfrjmxwjly")
    public suspend fun versionHeaderName(`value`: Output<String>) {
        this.versionHeaderName = value
    }

    /**
     * @param value Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
     */
    @JvmName("cxqbhtjunglhpqfq")
    public suspend fun versionQueryName(`value`: Output<String>) {
        this.versionQueryName = value
    }

    /**
     * @param value An value that determines where the API Version identifier will be located in a HTTP request.
     */
    @JvmName("cbddnpwdyfufdrxa")
    public suspend fun versioningScheme(`value`: Output<Either<String, VersioningScheme>>) {
        this.versioningScheme = value
    }

    /**
     * @param value Description of API Version Set.
     */
    @JvmName("aywhlhbhylksuemd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Identifier for existing API Version Set. Omit this value to create a new Version Set.
     */
    @JvmName("voawmlnhigoknkro")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The display Name of the API Version Set.
     */
    @JvmName("tqsjxqmhfgvqtqer")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
     */
    @JvmName("khfnsclpxjbykrrn")
    public suspend fun versionHeaderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionHeaderName = mapped
    }

    /**
     * @param value Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
     */
    @JvmName("fvskkbnhucgsnhrj")
    public suspend fun versionQueryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionQueryName = mapped
    }

    /**
     * @param value An value that determines where the API Version identifier will be located in a HTTP request.
     */
    @JvmName("bsssnwvucohtgbti")
    public suspend fun versioningScheme(`value`: Either<String, VersioningScheme>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versioningScheme = mapped
    }

    /**
     * @param value An value that determines where the API Version identifier will be located in a HTTP request.
     */
    @JvmName("gdepgkxvbudjpftl")
    public fun versioningScheme(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VersioningScheme>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.versioningScheme = mapped
    }

    /**
     * @param value An value that determines where the API Version identifier will be located in a HTTP request.
     */
    @JvmName("uobargbvwfkglfqk")
    public fun versioningScheme(`value`: VersioningScheme) {
        val toBeMapped = Either.ofRight<String, VersioningScheme>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.versioningScheme = mapped
    }

    internal fun build(): ApiVersionSetContractDetailsArgs = ApiVersionSetContractDetailsArgs(
        description = description,
        id = id,
        name = name,
        versionHeaderName = versionHeaderName,
        versionQueryName = versionQueryName,
        versioningScheme = versioningScheme,
    )
}
