@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.AuthorizationErrorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Authorization error details.
 * @property code Error code
 * @property message Error message
 */
public data class AuthorizationErrorArgs(
    public val code: Output<String>? = null,
    public val message: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.AuthorizationErrorArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.AuthorizationErrorArgs =
        com.pulumi.azurenative.apimanagement.inputs.AuthorizationErrorArgs.builder()
            .code(code?.applyValue({ args0 -> args0 }))
            .message(message?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthorizationErrorArgs].
 */
@PulumiTagMarker
public class AuthorizationErrorArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    private var message: Output<String>? = null

    /**
     * @param value Error code
     */
    @JvmName("wpfhxwgqnesqlxgf")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value Error message
     */
    @JvmName("kaewolbyrrxtdtcb")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value Error code
     */
    @JvmName("rtjbnjpekslxlvdx")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Error message
     */
    @JvmName("upifdeydplvqwtfg")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    internal fun build(): AuthorizationErrorArgs = AuthorizationErrorArgs(
        code = code,
        message = message,
    )
}
