@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.AuthorizationProviderOAuth2GrantTypesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Authorization Provider oauth2 grant types settings
 * @property authorizationCode OAuth2 authorization code grant parameters
 * @property clientCredentials OAuth2 client credential grant parameters
 */
public data class AuthorizationProviderOAuth2GrantTypesArgs(
    public val authorizationCode: Output<Map<String, String>>? = null,
    public val clientCredentials: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.AuthorizationProviderOAuth2GrantTypesArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.AuthorizationProviderOAuth2GrantTypesArgs =
        com.pulumi.azurenative.apimanagement.inputs.AuthorizationProviderOAuth2GrantTypesArgs.builder()
            .authorizationCode(
                authorizationCode?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .clientCredentials(
                clientCredentials?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AuthorizationProviderOAuth2GrantTypesArgs].
 */
@PulumiTagMarker
public class AuthorizationProviderOAuth2GrantTypesArgsBuilder internal constructor() {
    private var authorizationCode: Output<Map<String, String>>? = null

    private var clientCredentials: Output<Map<String, String>>? = null

    /**
     * @param value OAuth2 authorization code grant parameters
     */
    @JvmName("unrispgxkxvwxrpp")
    public suspend fun authorizationCode(`value`: Output<Map<String, String>>) {
        this.authorizationCode = value
    }

    /**
     * @param value OAuth2 client credential grant parameters
     */
    @JvmName("nxwsgvhmdgnabpeq")
    public suspend fun clientCredentials(`value`: Output<Map<String, String>>) {
        this.clientCredentials = value
    }

    /**
     * @param value OAuth2 authorization code grant parameters
     */
    @JvmName("ckrprsglyuxclbba")
    public suspend fun authorizationCode(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationCode = mapped
    }

    /**
     * @param values OAuth2 authorization code grant parameters
     */
    @JvmName("jygaffmqjqdnritt")
    public fun authorizationCode(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationCode = mapped
    }

    /**
     * @param value OAuth2 client credential grant parameters
     */
    @JvmName("ukymkikrjysbhrer")
    public suspend fun clientCredentials(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCredentials = mapped
    }

    /**
     * @param values OAuth2 client credential grant parameters
     */
    @JvmName("tpkiwnrldrgjbdeo")
    public fun clientCredentials(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientCredentials = mapped
    }

    internal fun build(): AuthorizationProviderOAuth2GrantTypesArgs =
        AuthorizationProviderOAuth2GrantTypesArgs(
            authorizationCode = authorizationCode,
            clientCredentials = clientCredentials,
        )
}
