@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.AuthorizationProviderOAuth2SettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * OAuth2 settings details
 * @property grantTypes OAuth2 settings
 * @property redirectUrl Redirect URL to be set in the OAuth application.
 */
public data class AuthorizationProviderOAuth2SettingsArgs(
    public val grantTypes: Output<AuthorizationProviderOAuth2GrantTypesArgs>? = null,
    public val redirectUrl: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.AuthorizationProviderOAuth2SettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.AuthorizationProviderOAuth2SettingsArgs =
        com.pulumi.azurenative.apimanagement.inputs.AuthorizationProviderOAuth2SettingsArgs.builder()
            .grantTypes(grantTypes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .redirectUrl(redirectUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthorizationProviderOAuth2SettingsArgs].
 */
@PulumiTagMarker
public class AuthorizationProviderOAuth2SettingsArgsBuilder internal constructor() {
    private var grantTypes: Output<AuthorizationProviderOAuth2GrantTypesArgs>? = null

    private var redirectUrl: Output<String>? = null

    /**
     * @param value OAuth2 settings
     */
    @JvmName("yypjbkxfniqoujmp")
    public suspend fun grantTypes(`value`: Output<AuthorizationProviderOAuth2GrantTypesArgs>) {
        this.grantTypes = value
    }

    /**
     * @param value Redirect URL to be set in the OAuth application.
     */
    @JvmName("ipboevycsqcywgqh")
    public suspend fun redirectUrl(`value`: Output<String>) {
        this.redirectUrl = value
    }

    /**
     * @param value OAuth2 settings
     */
    @JvmName("pyqgxndgqexmrcan")
    public suspend fun grantTypes(`value`: AuthorizationProviderOAuth2GrantTypesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grantTypes = mapped
    }

    /**
     * @param argument OAuth2 settings
     */
    @JvmName("kfcmmpludibmuaif")
    public suspend
    fun grantTypes(argument: suspend AuthorizationProviderOAuth2GrantTypesArgsBuilder.() -> Unit) {
        val toBeMapped = AuthorizationProviderOAuth2GrantTypesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.grantTypes = mapped
    }

    /**
     * @param value Redirect URL to be set in the OAuth application.
     */
    @JvmName("tqipgbwsfvkhsrgk")
    public suspend fun redirectUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectUrl = mapped
    }

    internal fun build(): AuthorizationProviderOAuth2SettingsArgs =
        AuthorizationProviderOAuth2SettingsArgs(
            grantTypes = grantTypes,
            redirectUrl = redirectUrl,
        )
}
