@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.BackendCredentialsContractArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Details of the Credentials used to connect to Backend.
 * @property authorization Authorization header authentication
 * @property certificate List of Client Certificate Thumbprints. Will be ignored if certificatesIds are provided.
 * @property certificateIds List of Client Certificate Ids.
 * @property header Header Parameter description.
 * @property query Query Parameter description.
 */
public data class BackendCredentialsContractArgs(
    public val authorization: Output<BackendAuthorizationHeaderCredentialsArgs>? = null,
    public val certificate: Output<List<String>>? = null,
    public val certificateIds: Output<List<String>>? = null,
    public val `header`: Output<Map<String, List<String>>>? = null,
    public val query: Output<Map<String, List<String>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.BackendCredentialsContractArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.BackendCredentialsContractArgs =
        com.pulumi.azurenative.apimanagement.inputs.BackendCredentialsContractArgs.builder()
            .authorization(authorization?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .certificate(certificate?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .certificateIds(certificateIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .`header`(
                `header`?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.map({ args0 -> args0 }))
                    }).toMap()
                }),
            )
            .query(
                query?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.map({ args0 ->
                                args0
                            }),
                        )
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BackendCredentialsContractArgs].
 */
@PulumiTagMarker
public class BackendCredentialsContractArgsBuilder internal constructor() {
    private var authorization: Output<BackendAuthorizationHeaderCredentialsArgs>? = null

    private var certificate: Output<List<String>>? = null

    private var certificateIds: Output<List<String>>? = null

    private var `header`: Output<Map<String, List<String>>>? = null

    private var query: Output<Map<String, List<String>>>? = null

    /**
     * @param value Authorization header authentication
     */
    @JvmName("gsglwlxlvwsdntle")
    public suspend fun authorization(`value`: Output<BackendAuthorizationHeaderCredentialsArgs>) {
        this.authorization = value
    }

    /**
     * @param value List of Client Certificate Thumbprints. Will be ignored if certificatesIds are provided.
     */
    @JvmName("ylpqbrcdotluuohi")
    public suspend fun certificate(`value`: Output<List<String>>) {
        this.certificate = value
    }

    @JvmName("ydoedrovcicbvapy")
    public suspend fun certificate(vararg values: Output<String>) {
        this.certificate = Output.all(values.asList())
    }

    /**
     * @param values List of Client Certificate Thumbprints. Will be ignored if certificatesIds are provided.
     */
    @JvmName("yhbtguetkkulifme")
    public suspend fun certificate(values: List<Output<String>>) {
        this.certificate = Output.all(values)
    }

    /**
     * @param value List of Client Certificate Ids.
     */
    @JvmName("qvptsuknkjqcttik")
    public suspend fun certificateIds(`value`: Output<List<String>>) {
        this.certificateIds = value
    }

    @JvmName("hscsxggokvepdquk")
    public suspend fun certificateIds(vararg values: Output<String>) {
        this.certificateIds = Output.all(values.asList())
    }

    /**
     * @param values List of Client Certificate Ids.
     */
    @JvmName("ptdfmdfjhqhkwtob")
    public suspend fun certificateIds(values: List<Output<String>>) {
        this.certificateIds = Output.all(values)
    }

    /**
     * @param value Header Parameter description.
     */
    @JvmName("xodfhflpxrhkkirn")
    public suspend fun `header`(`value`: Output<Map<String, List<String>>>) {
        this.`header` = value
    }

    /**
     * @param value Query Parameter description.
     */
    @JvmName("ifnyqcvkxndvdttj")
    public suspend fun query(`value`: Output<Map<String, List<String>>>) {
        this.query = value
    }

    /**
     * @param value Authorization header authentication
     */
    @JvmName("mktwsuunbljyjsyo")
    public suspend fun authorization(`value`: BackendAuthorizationHeaderCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorization = mapped
    }

    /**
     * @param argument Authorization header authentication
     */
    @JvmName("xxojsvbkrkmnawot")
    public suspend
    fun authorization(argument: suspend BackendAuthorizationHeaderCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = BackendAuthorizationHeaderCredentialsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authorization = mapped
    }

    /**
     * @param value List of Client Certificate Thumbprints. Will be ignored if certificatesIds are provided.
     */
    @JvmName("qkbhumhirwnumxdc")
    public suspend fun certificate(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param values List of Client Certificate Thumbprints. Will be ignored if certificatesIds are provided.
     */
    @JvmName("tlclhdsioerlxtye")
    public suspend fun certificate(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value List of Client Certificate Ids.
     */
    @JvmName("nmnciabwvyakhccn")
    public suspend fun certificateIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateIds = mapped
    }

    /**
     * @param values List of Client Certificate Ids.
     */
    @JvmName("kvtlcrmkicgcewby")
    public suspend fun certificateIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateIds = mapped
    }

    /**
     * @param value Header Parameter description.
     */
    @JvmName("dswmlfcvujymgobk")
    public suspend fun `header`(`value`: Map<String, List<String>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`header` = mapped
    }

    /**
     * @param values Header Parameter description.
     */
    @JvmName("wrqxvdteluysfyki")
    public fun `header`(vararg values: Pair<String, List<String>>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`header` = mapped
    }

    /**
     * @param value Query Parameter description.
     */
    @JvmName("hehxxkemjvbabxgo")
    public suspend fun query(`value`: Map<String, List<String>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param values Query Parameter description.
     */
    @JvmName("vqsvfblhxfuhuguu")
    public fun query(vararg values: Pair<String, List<String>>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.query = mapped
    }

    internal fun build(): BackendCredentialsContractArgs = BackendCredentialsContractArgs(
        authorization = authorization,
        certificate = certificate,
        certificateIds = certificateIds,
        `header` = `header`,
        query = query,
    )
}
