@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.BackendServiceFabricClusterPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of the Service Fabric Type Backend.
 * @property clientCertificateId The client certificate id for the management endpoint.
 * @property clientCertificatethumbprint The client certificate thumbprint for the management endpoint. Will be ignored if certificatesIds are provided
 * @property managementEndpoints The cluster management endpoint.
 * @property maxPartitionResolutionRetries Maximum number of retries while attempting resolve the partition.
 * @property serverCertificateThumbprints Thumbprints of certificates cluster management service uses for tls communication
 * @property serverX509Names Server X509 Certificate Names Collection
 */
public data class BackendServiceFabricClusterPropertiesArgs(
    public val clientCertificateId: Output<String>? = null,
    public val clientCertificatethumbprint: Output<String>? = null,
    public val managementEndpoints: Output<List<String>>,
    public val maxPartitionResolutionRetries: Output<Int>? = null,
    public val serverCertificateThumbprints: Output<List<String>>? = null,
    public val serverX509Names: Output<List<X509CertificateNameArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.BackendServiceFabricClusterPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.BackendServiceFabricClusterPropertiesArgs =
        com.pulumi.azurenative.apimanagement.inputs.BackendServiceFabricClusterPropertiesArgs.builder()
            .clientCertificateId(clientCertificateId?.applyValue({ args0 -> args0 }))
            .clientCertificatethumbprint(clientCertificatethumbprint?.applyValue({ args0 -> args0 }))
            .managementEndpoints(managementEndpoints.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxPartitionResolutionRetries(maxPartitionResolutionRetries?.applyValue({ args0 -> args0 }))
            .serverCertificateThumbprints(
                serverCertificateThumbprints?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .serverX509Names(
                serverX509Names?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BackendServiceFabricClusterPropertiesArgs].
 */
@PulumiTagMarker
public class BackendServiceFabricClusterPropertiesArgsBuilder internal constructor() {
    private var clientCertificateId: Output<String>? = null

    private var clientCertificatethumbprint: Output<String>? = null

    private var managementEndpoints: Output<List<String>>? = null

    private var maxPartitionResolutionRetries: Output<Int>? = null

    private var serverCertificateThumbprints: Output<List<String>>? = null

    private var serverX509Names: Output<List<X509CertificateNameArgs>>? = null

    /**
     * @param value The client certificate id for the management endpoint.
     */
    @JvmName("yorqdeufpkahdgrr")
    public suspend fun clientCertificateId(`value`: Output<String>) {
        this.clientCertificateId = value
    }

    /**
     * @param value The client certificate thumbprint for the management endpoint. Will be ignored if certificatesIds are provided
     */
    @JvmName("krxacwpgfvcojseh")
    public suspend fun clientCertificatethumbprint(`value`: Output<String>) {
        this.clientCertificatethumbprint = value
    }

    /**
     * @param value The cluster management endpoint.
     */
    @JvmName("awpksajtcpysebhe")
    public suspend fun managementEndpoints(`value`: Output<List<String>>) {
        this.managementEndpoints = value
    }

    @JvmName("aclfkyusiowirbmp")
    public suspend fun managementEndpoints(vararg values: Output<String>) {
        this.managementEndpoints = Output.all(values.asList())
    }

    /**
     * @param values The cluster management endpoint.
     */
    @JvmName("jpbvwqjmjooaqpyx")
    public suspend fun managementEndpoints(values: List<Output<String>>) {
        this.managementEndpoints = Output.all(values)
    }

    /**
     * @param value Maximum number of retries while attempting resolve the partition.
     */
    @JvmName("duwcpbvhqnpendti")
    public suspend fun maxPartitionResolutionRetries(`value`: Output<Int>) {
        this.maxPartitionResolutionRetries = value
    }

    /**
     * @param value Thumbprints of certificates cluster management service uses for tls communication
     */
    @JvmName("bpyhulypadrbnmkd")
    public suspend fun serverCertificateThumbprints(`value`: Output<List<String>>) {
        this.serverCertificateThumbprints = value
    }

    @JvmName("pqlfhgpigoekuinu")
    public suspend fun serverCertificateThumbprints(vararg values: Output<String>) {
        this.serverCertificateThumbprints = Output.all(values.asList())
    }

    /**
     * @param values Thumbprints of certificates cluster management service uses for tls communication
     */
    @JvmName("ncijamnmgebivqbl")
    public suspend fun serverCertificateThumbprints(values: List<Output<String>>) {
        this.serverCertificateThumbprints = Output.all(values)
    }

    /**
     * @param value Server X509 Certificate Names Collection
     */
    @JvmName("kioaydewhscyqxgd")
    public suspend fun serverX509Names(`value`: Output<List<X509CertificateNameArgs>>) {
        this.serverX509Names = value
    }

    @JvmName("athhggeegrriypwx")
    public suspend fun serverX509Names(vararg values: Output<X509CertificateNameArgs>) {
        this.serverX509Names = Output.all(values.asList())
    }

    /**
     * @param values Server X509 Certificate Names Collection
     */
    @JvmName("aoawnkpfgpmbmoir")
    public suspend fun serverX509Names(values: List<Output<X509CertificateNameArgs>>) {
        this.serverX509Names = Output.all(values)
    }

    /**
     * @param value The client certificate id for the management endpoint.
     */
    @JvmName("tjmkfrciiivtxcvs")
    public suspend fun clientCertificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertificateId = mapped
    }

    /**
     * @param value The client certificate thumbprint for the management endpoint. Will be ignored if certificatesIds are provided
     */
    @JvmName("oyimebiwgfccalsg")
    public suspend fun clientCertificatethumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertificatethumbprint = mapped
    }

    /**
     * @param value The cluster management endpoint.
     */
    @JvmName("pmuxgwxsmnsxnkve")
    public suspend fun managementEndpoints(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managementEndpoints = mapped
    }

    /**
     * @param values The cluster management endpoint.
     */
    @JvmName("erdpbtynsetcvgdl")
    public suspend fun managementEndpoints(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managementEndpoints = mapped
    }

    /**
     * @param value Maximum number of retries while attempting resolve the partition.
     */
    @JvmName("dbfwvgagvryjjgbu")
    public suspend fun maxPartitionResolutionRetries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPartitionResolutionRetries = mapped
    }

    /**
     * @param value Thumbprints of certificates cluster management service uses for tls communication
     */
    @JvmName("nhqtenkibriggrsm")
    public suspend fun serverCertificateThumbprints(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCertificateThumbprints = mapped
    }

    /**
     * @param values Thumbprints of certificates cluster management service uses for tls communication
     */
    @JvmName("xyygtidjgphsqfja")
    public suspend fun serverCertificateThumbprints(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverCertificateThumbprints = mapped
    }

    /**
     * @param value Server X509 Certificate Names Collection
     */
    @JvmName("wmvuvsufrvdopdml")
    public suspend fun serverX509Names(`value`: List<X509CertificateNameArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverX509Names = mapped
    }

    /**
     * @param argument Server X509 Certificate Names Collection
     */
    @JvmName("fxlgohnfrbhpqjxe")
    public suspend
    fun serverX509Names(argument: List<suspend X509CertificateNameArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            X509CertificateNameArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serverX509Names = mapped
    }

    /**
     * @param argument Server X509 Certificate Names Collection
     */
    @JvmName("pudjffiqtkcjjoca")
    public suspend fun serverX509Names(
        vararg
        argument: suspend X509CertificateNameArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            X509CertificateNameArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serverX509Names = mapped
    }

    /**
     * @param argument Server X509 Certificate Names Collection
     */
    @JvmName("qapriebeeqqrhxgx")
    public suspend fun serverX509Names(argument: suspend X509CertificateNameArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(X509CertificateNameArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.serverX509Names = mapped
    }

    /**
     * @param values Server X509 Certificate Names Collection
     */
    @JvmName("bhpsaiodfyjwivrq")
    public suspend fun serverX509Names(vararg values: X509CertificateNameArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverX509Names = mapped
    }

    internal fun build(): BackendServiceFabricClusterPropertiesArgs =
        BackendServiceFabricClusterPropertiesArgs(
            clientCertificateId = clientCertificateId,
            clientCertificatethumbprint = clientCertificatethumbprint,
            managementEndpoints = managementEndpoints ?: throw PulumiNullFieldException("managementEndpoints"),
            maxPartitionResolutionRetries = maxPartitionResolutionRetries,
            serverCertificateThumbprints = serverCertificateThumbprints,
            serverX509Names = serverX509Names,
        )
}
