@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.DataMaskingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property headers Masking settings for headers
 * @property queryParams Masking settings for Url query parameters
 */
public data class DataMaskingArgs(
    public val headers: Output<List<DataMaskingEntityArgs>>? = null,
    public val queryParams: Output<List<DataMaskingEntityArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.DataMaskingArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.DataMaskingArgs =
        com.pulumi.azurenative.apimanagement.inputs.DataMaskingArgs.builder()
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .queryParams(
                queryParams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DataMaskingArgs].
 */
@PulumiTagMarker
public class DataMaskingArgsBuilder internal constructor() {
    private var headers: Output<List<DataMaskingEntityArgs>>? = null

    private var queryParams: Output<List<DataMaskingEntityArgs>>? = null

    /**
     * @param value Masking settings for headers
     */
    @JvmName("iguaotjmrtrikadu")
    public suspend fun headers(`value`: Output<List<DataMaskingEntityArgs>>) {
        this.headers = value
    }

    @JvmName("qubptjhxmhbaduqq")
    public suspend fun headers(vararg values: Output<DataMaskingEntityArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Masking settings for headers
     */
    @JvmName("gjuhkuikkidlprdq")
    public suspend fun headers(values: List<Output<DataMaskingEntityArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Masking settings for Url query parameters
     */
    @JvmName("kyebbifsrpdqmvlt")
    public suspend fun queryParams(`value`: Output<List<DataMaskingEntityArgs>>) {
        this.queryParams = value
    }

    @JvmName("lkmypfjlfrscbktr")
    public suspend fun queryParams(vararg values: Output<DataMaskingEntityArgs>) {
        this.queryParams = Output.all(values.asList())
    }

    /**
     * @param values Masking settings for Url query parameters
     */
    @JvmName("quvgdwoxjnlcwtru")
    public suspend fun queryParams(values: List<Output<DataMaskingEntityArgs>>) {
        this.queryParams = Output.all(values)
    }

    /**
     * @param value Masking settings for headers
     */
    @JvmName("gxopgpfvutpfypxk")
    public suspend fun headers(`value`: List<DataMaskingEntityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Masking settings for headers
     */
    @JvmName("difsjmyjohffudeh")
    public suspend fun headers(argument: List<suspend DataMaskingEntityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataMaskingEntityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Masking settings for headers
     */
    @JvmName("udunujqejjpqroax")
    public suspend fun headers(vararg argument: suspend DataMaskingEntityArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataMaskingEntityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Masking settings for headers
     */
    @JvmName("rrwmycqojisptlnc")
    public suspend fun headers(argument: suspend DataMaskingEntityArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataMaskingEntityArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Masking settings for headers
     */
    @JvmName("ihxemucrnycnfcei")
    public suspend fun headers(vararg values: DataMaskingEntityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Masking settings for Url query parameters
     */
    @JvmName("mlnsaanvcisditgu")
    public suspend fun queryParams(`value`: List<DataMaskingEntityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryParams = mapped
    }

    /**
     * @param argument Masking settings for Url query parameters
     */
    @JvmName("jumnxolswvnkpifr")
    public suspend fun queryParams(argument: List<suspend DataMaskingEntityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataMaskingEntityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queryParams = mapped
    }

    /**
     * @param argument Masking settings for Url query parameters
     */
    @JvmName("haysucurfjxqvqnb")
    public suspend fun queryParams(vararg argument: suspend DataMaskingEntityArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataMaskingEntityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queryParams = mapped
    }

    /**
     * @param argument Masking settings for Url query parameters
     */
    @JvmName("jdvalmbdsgkclxia")
    public suspend fun queryParams(argument: suspend DataMaskingEntityArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataMaskingEntityArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.queryParams = mapped
    }

    /**
     * @param values Masking settings for Url query parameters
     */
    @JvmName("rwyjvudxjiimdxek")
    public suspend fun queryParams(vararg values: DataMaskingEntityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryParams = mapped
    }

    internal fun build(): DataMaskingArgs = DataMaskingArgs(
        headers = headers,
        queryParams = queryParams,
    )
}
