@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.DataMaskingEntityArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.DataMaskingMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mode Data masking mode.
 * @property value The name of an entity to mask (e.g. a name of a header or a query parameter).
 */
public data class DataMaskingEntityArgs(
    public val mode: Output<Either<String, DataMaskingMode>>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.DataMaskingEntityArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.DataMaskingEntityArgs =
        com.pulumi.azurenative.apimanagement.inputs.DataMaskingEntityArgs.builder()
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataMaskingEntityArgs].
 */
@PulumiTagMarker
public class DataMaskingEntityArgsBuilder internal constructor() {
    private var mode: Output<Either<String, DataMaskingMode>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Data masking mode.
     */
    @JvmName("veeghauvwyxvsuiq")
    public suspend fun mode(`value`: Output<Either<String, DataMaskingMode>>) {
        this.mode = value
    }

    /**
     * @param value The name of an entity to mask (e.g. a name of a header or a query parameter).
     */
    @JvmName("aetgutftohrgxiad")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Data masking mode.
     */
    @JvmName("vxcwkekabyobycli")
    public suspend fun mode(`value`: Either<String, DataMaskingMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Data masking mode.
     */
    @JvmName("obvnauixnqiehgxh")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataMaskingMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Data masking mode.
     */
    @JvmName("tdspkxfnxcwvykmj")
    public fun mode(`value`: DataMaskingMode) {
        val toBeMapped = Either.ofRight<String, DataMaskingMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The name of an entity to mask (e.g. a name of a header or a query parameter).
     */
    @JvmName("fmxanhcdlndngybb")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): DataMaskingEntityArgs = DataMaskingEntityArgs(
        mode = mode,
        `value` = `value`,
    )
}
