@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetContentTypePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contentTypeId Content type identifier.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetContentTypePlainArgs(
    public val contentTypeId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetContentTypePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetContentTypePlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetContentTypePlainArgs.builder()
            .contentTypeId(contentTypeId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContentTypePlainArgs].
 */
@PulumiTagMarker
public class GetContentTypePlainArgsBuilder internal constructor() {
    private var contentTypeId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Content type identifier.
     */
    @JvmName("qwjnhlspbklcivyp")
    public suspend fun contentTypeId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.contentTypeId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("esdqdsmcxfapimus")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("rcvvpgjduiwtnlpg")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetContentTypePlainArgs = GetContentTypePlainArgs(
        contentTypeId = contentTypeId ?: throw PulumiNullFieldException("contentTypeId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
